/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TableItem;

public class CellTicker {
    public static final int BACKGROUND = 1;
    public static final int FOREGROUND = 2;
    private int style;
    private int interval = 5;
    private Color foreground;
    private Color background;
    private Color incrementForeground;
    private Color incrementBackground;
    private Color decrementForeground;
    private Color decrementBackground;
    private TableItem tableItem;
    private Status rowStatus;
    private List status = new ArrayList();

    public CellTicker(TableItem tableItem, int style) {
        this.tableItem = tableItem;
        this.style = style;
        while (this.status.size() < tableItem.getParent().getColumnCount()) {
            this.status.add(new Status());
        }
        this.rowStatus = new Status();
        this.rowStatus.item = tableItem;
    }

    public void dispose() {
    }

    public void tick(int index) {
        this.tick(index, this.background, this.foreground);
    }

    public void tickIncrement(int index) {
        this.tick(index, this.incrementBackground, this.incrementForeground);
    }

    public void tickDecrement(int index) {
        this.tick(index, this.decrementBackground, this.decrementForeground);
    }

    public synchronized void tick(int index, Color background, Color foreground) {
        while (this.status.size() < index + 1) {
            this.status.add(new Status());
        }
        Status s = (Status)this.status.get(index);
        if (s.started == 0L && this.rowStatus.started == 0L) {
            s.item = this.tableItem;
            s.index = index;
            if ((this.style & 1) != 0) {
                s.bg = this.tableItem.getBackground(index);
                Color bg = this.tableItem.getBackground();
                if (bg.equals((Object)s.bg)) {
                    s.bg = null;
                }
                if (background != null) {
                    this.tableItem.setBackground(index, background);
                }
            }
            if ((this.style & 2) != 0) {
                s.fg = this.tableItem.getForeground(index);
                Color fg = this.tableItem.getForeground();
                if (fg.equals((Object)s.fg)) {
                    s.fg = null;
                }
                if (foreground != null) {
                    this.tableItem.setForeground(index, foreground);
                }
            }
            s.started = System.currentTimeMillis();
            this.tableItem.getDisplay().timerExec(this.interval * 1000, (Runnable)s);
        }
    }

    public synchronized void tick(Color background, Color foreground) {
        if (this.rowStatus.started == 0L) {
            Status[] stats = this.status.toArray(new Status[0]);
            int i = 0;
            while (i < stats.length) {
                stats[i].run();
                ++i;
            }
            if ((this.style & 1) != 0) {
                this.rowStatus.bg = this.tableItem.getBackground();
                if (background != null) {
                    this.tableItem.setBackground(background);
                }
            }
            if ((this.style & 2) != 0) {
                this.rowStatus.fg = this.tableItem.getForeground();
                if (foreground != null) {
                    this.tableItem.setForeground(foreground);
                }
            }
            this.rowStatus.started = System.currentTimeMillis();
            this.tableItem.getDisplay().timerExec(this.interval * 1000, (Runnable)this.rowStatus);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getDecrementBackground() {
        return this.decrementBackground;
    }

    public void setDecrementBackground(Color decrementBackground) {
        this.decrementBackground = decrementBackground;
    }

    public Color getDecrementForeground() {
        return this.decrementForeground;
    }

    public void setDecrementForeground(Color decrementForeground) {
        this.decrementForeground = decrementForeground;
    }

    public Color getIncrementBackground() {
        return this.incrementBackground;
    }

    public void setIncrementBackground(Color incrementBackground) {
        this.incrementBackground = incrementBackground;
    }

    public Color getIncrementForeground() {
        return this.incrementForeground;
    }

    public void setIncrementForeground(Color incrementForeground) {
        this.incrementForeground = incrementForeground;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    private class Status
    implements Runnable {
        TableItem item;
        int index = -1;
        Color bg;
        Color fg;
        long started = 0L;

        private Status() {
        }

        @Override
        public void run() {
            if (this.item != null && !this.item.isDisposed() && this.started != 0L) {
                if (this.index == -1) {
                    this.item.setBackground(this.bg);
                } else {
                    this.item.setBackground(this.index, this.bg);
                }
                if (this.bg != null) {
                    this.bg = null;
                }
                if (this.index == -1) {
                    this.item.setForeground(this.fg);
                } else {
                    this.item.setForeground(this.index, this.fg);
                }
                if (this.fg != null) {
                    this.fg = null;
                }
            }
            this.started = 0L;
        }
    }
}

