/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import org.eclipse.swt.graphics.Color;
import pk.com.softech.tradingterminal.trading.internal.Box;

public class BoxTicker {
    public static final int BACKGROUND = 1;
    public static final int FOREGROUND = 2;
    private int style;
    private int interval = 5;
    private Color foreground;
    private Color background;
    private Color incrementForeground;
    private Color incrementBackground;
    private Color decrementForeground;
    private Color decrementBackground;
    private Box tableItem;
    private Status rowStatus;

    public BoxTicker(Box tableItem, int style) {
        this.tableItem = tableItem;
        this.style = style;
        this.rowStatus = new Status();
        this.rowStatus.item = tableItem;
    }

    public void dispose() {
    }

    public void tick() {
        this.tick(this.background, this.foreground);
    }

    public synchronized void tick(Color background, Color foreground) {
        if (this.rowStatus.started == 0L) {
            this.rowStatus.item = this.tableItem;
            if ((this.style & 1) != 0) {
                this.rowStatus.bg = this.tableItem.getBackground();
                if (background != null) {
                    this.tableItem.setBackground(background);
                }
            }
            if ((this.style & 2) != 0) {
                this.rowStatus.fg = this.tableItem.getForeground();
                if (foreground != null) {
                    this.tableItem.setForeground(foreground);
                }
            }
            this.rowStatus.started = System.currentTimeMillis();
            this.tableItem.getDisplay().timerExec(this.interval * 1000, (Runnable)this.rowStatus);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getDecrementBackground() {
        return this.decrementBackground;
    }

    public void setDecrementBackground(Color decrementBackground) {
        this.decrementBackground = decrementBackground;
    }

    public Color getDecrementForeground() {
        return this.decrementForeground;
    }

    public void setDecrementForeground(Color decrementForeground) {
        this.decrementForeground = decrementForeground;
    }

    public Color getIncrementBackground() {
        return this.incrementBackground;
    }

    public void setIncrementBackground(Color incrementBackground) {
        this.incrementBackground = incrementBackground;
    }

    public Color getIncrementForeground() {
        return this.incrementForeground;
    }

    public void setIncrementForeground(Color incrementForeground) {
        this.incrementForeground = incrementForeground;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    private class Status
    implements Runnable {
        Box item;
        Color bg;
        Color fg;
        long started = 0L;

        private Status() {
        }

        @Override
        public void run() {
            if (this.item != null && !this.item.isDisposed() && this.started != 0L) {
                this.item.setBackground(this.bg);
                if (this.bg != null) {
                    this.bg = null;
                }
                this.item.setForeground(this.fg);
                if (this.fg != null) {
                    this.fg = null;
                }
            }
            this.started = 0L;
        }
    }
}

