/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class Box
extends Canvas
implements PaintListener {
    Composite row1;
    Composite row2;
    Label name;
    Label turnover;
    Label currentIndes;
    Label change;
    Color background = new Color(null, 255, 255, 255);
    Color foreground = new Color(null, 0, 0, 0);
    Color negativeForeground = new Color(null, 240, 0, 0);
    Color positiveForeground = new Color(null, 0, 192, 0);
    List selectionListeners = new ArrayList();
    MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            Event event = new Event();
            event.display = e.display;
            event.x = e.x;
            event.y = e.y;
            event.item = Box.this;
            event.widget = Box.this;
            event.time = e.time;
            SelectionEvent selection = new SelectionEvent(event);
            SelectionListener[] listeners = Box.this.selectionListeners.toArray(new SelectionListener[Box.this.selectionListeners.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].widgetSelected(selection);
                ++i;
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    };

    public Box(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        super.setBackground(this.background);
        this.addPaintListener(this);
        GridData data = new GridData(200, 20);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.row1 = new Composite((Composite)this, 0);
        this.row1.setLayout((Layout)gridLayout);
        this.row1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.row1.setLayoutData((Object)data);
        this.row1.setBackground(this.background);
        this.name = new Label(this.row1, 0);
        this.name.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.name.setForeground(this.foreground);
        this.name.setBackground(this.background);
        this.turnover = new Label(this.row1, 0);
        this.turnover.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.turnover.setForeground(this.foreground);
        this.turnover.setBackground(this.background);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.row2 = new Composite((Composite)this, 0);
        this.row2.setLayout((Layout)gridLayout);
        this.row2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.row2.setLayoutData((Object)data);
        this.row2.setBackground(this.background);
        this.currentIndes = new Label(this.row2, 0);
        this.currentIndes.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        this.currentIndes.setForeground(this.foreground);
        this.currentIndes.setBackground(this.background);
        this.change = new Label(this.row2, 0);
        this.change.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        this.change.setForeground(this.foreground);
        this.change.setBackground(this.background);
        this.change.setForeground(this.negativeForeground);
        this.row1.addMouseListener(this.mouseListener);
        this.name.addMouseListener(this.mouseListener);
        this.turnover.addMouseListener(this.mouseListener);
        this.row2.addMouseListener(this.mouseListener);
        this.currentIndes.addMouseListener(this.mouseListener);
        this.change.addMouseListener(this.mouseListener);
        this.addMouseListener(this.mouseListener);
    }

    public void dispose() {
        this.background.dispose();
        this.foreground.dispose();
        this.negativeForeground.dispose();
        this.positiveForeground.dispose();
        super.dispose();
    }

    public void setMenu(Menu menu) {
        this.row1.setMenu(menu);
        this.name.setMenu(menu);
        this.turnover.setMenu(menu);
        this.row2.setMenu(menu);
        this.currentIndes.setMenu(menu);
        this.change.setMenu(menu);
        super.setMenu(menu);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setChange(String change) {
        this.change.setText(change);
        if (change.startsWith("-")) {
            this.change.setForeground(this.negativeForeground);
        } else if (change.startsWith("+")) {
            this.change.setForeground(this.positiveForeground);
        } else {
            this.change.setForeground(this.foreground);
        }
    }

    public void setName(String name) {
        name = name.replaceAll("[&]", "&&");
        this.name.setText(name);
    }

    public void setTurnover(String time) {
        this.turnover.setText(time);
    }

    public void setCurrentIndex(String value) {
        this.currentIndes.setText(value);
    }

    public void clear() {
        this.name.setText("");
        this.currentIndes.setText("");
        this.change.setText("");
        this.turnover.setText("");
    }

    public void paintControl(PaintEvent e) {
        e.gc.setForeground(this.foreground);
        Rectangle rect = this.getClientArea();
        e.gc.drawRectangle(0, 0, rect.width - 1, rect.height - 1);
    }

    public Color getBackground() {
        return new Color(null, this.background.getRGB());
    }

    public Color getForeground() {
        return new Color(null, this.foreground.getRGB());
    }

    public void setBackground(Color background) {
        if (this.background != null) {
            this.background.dispose();
        }
        this.background = new Color(null, background.getRGB());
        super.setBackground(background);
        this.row1.setBackground(background);
        this.name.setBackground(background);
        this.turnover.setBackground(background);
        this.row2.setBackground(background);
        this.currentIndes.setBackground(background);
        this.change.setBackground(background);
        this.change.getParent().setBackground(background);
    }

    public void setForeground(Color foreground) {
        if (this.foreground != null) {
            this.foreground.dispose();
        }
        this.foreground = new Color(null, foreground.getRGB());
        this.name.setForeground(foreground);
        this.turnover.setForeground(foreground);
        this.currentIndes.setForeground(foreground);
        if (!this.change.getText().startsWith("-") && !this.change.getText().startsWith("+")) {
            this.change.setForeground(foreground);
        }
        this.redraw();
    }

    public void setNegativeForeground(Color negativeForeground) {
        if (this.negativeForeground != null) {
            this.negativeForeground.dispose();
        }
        this.negativeForeground = new Color(null, negativeForeground.getRGB());
        if (this.change.getText().startsWith("-")) {
            this.change.setForeground(negativeForeground);
        }
    }

    public void setPositiveForeground(Color positiveForeground) {
        if (this.positiveForeground != null) {
            this.positiveForeground.dispose();
        }
        this.positiveForeground = new Color(null, positiveForeground.getRGB());
        if (this.change.getText().startsWith("+")) {
            this.change.setForeground(positiveForeground);
        }
    }

    public void setFont(Font font) {
        this.name.setFont(font);
        this.currentIndes.setFont(font);
        this.turnover.setFont(font);
        this.change.setFont(font);
    }

    public void setToolTip(String security) {
        this.name.setToolTipText(security);
    }
}

