/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.dialogs.PatternSearchDialog;
import pk.com.softech.tradingterminal.trading.internal.WatchlistPatternsSearchPage;
import pk.com.softech.tradingterminal.trading.views.PatternSearchView;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;

public class WatchlistPatternSearchDialog
extends PatternSearchDialog {
    protected Combo watchlists;

    public WatchlistPatternSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    public WatchlistPatternSearchDialog(IViewPart view) {
        super(view);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Watchlist");
        label.setLayoutData((Object)new GridData(125, -1));
        this.watchlists = new Combo(content, 8);
        this.watchlists.setLayoutData((Object)new GridData(4, 1, true, false));
        for (Watchlist list : CorePlugin.getRepository().allWatchlists()) {
            this.watchlists.add(list.getDescription());
            this.watchlists.setData(list.getDescription(), (Object)list);
        }
        if (this.view instanceof WatchlistView) {
            this.watchlists.setText(((WatchlistView)this.view).getWatchlist().getDescription());
        } else {
            this.watchlists.select(0);
        }
        return super.createDialogArea(content);
    }

    @Override
    public void okPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            PatternSearchView view = (PatternSearchView)page.showView("pk.com.softech.tradingterminal.patternSearch");
            Watchlist list = (Watchlist)this.watchlists.getData(this.watchlists.getText());
            int period = 8;
            switch (this.period.getSelectionIndex()) {
                case 0: {
                    period = 8;
                    break;
                }
                case 1: {
                    period = 9;
                    break;
                }
                case 2: {
                    period = 10;
                }
            }
            Date beginDate = null;
            Date endDate = null;
            try {
                if (this.begin.getText().length() != 0) {
                    beginDate = this.dateParse.parse(this.begin.getText());
                }
                if (this.end.getText().length() != 0) {
                    endDate = this.dateParse.parse(this.end.getText());
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
            WatchlistPatternsSearchPage searchPage = null;
            if (this.pattern.getData(this.pattern.getText()) != null) {
                IPattern plugin = CorePlugin.createPatternPlugin((String)((String)this.pattern.getData(this.pattern.getText())));
                searchPage = new WatchlistPatternsSearchPage(list, plugin, this.pattern.getText(), period, beginDate, endDate, this.bullishOnly.getSelection());
            } else {
                searchPage = new WatchlistPatternsSearchPage(list, period, beginDate, endDate, this.bullishOnly.getSelection());
            }
            searchPage.setAllOccurrences(this.allOccurrences.getSelection());
            view.addPage(searchPage);
        }
        catch (Exception e) {
            CorePlugin.logException((Exception)e);
        }
        super.okPressed();
    }
}

