/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Transaction;

public class TransactionDialog
extends TitleAreaDialog {
    Account account;
    Security security;
    int defaultQuantity = 1;
    Transaction transaction;
    Text dateText;
    Combo accountCombo;
    Combo securityCombo;
    Button buyButton;
    Button sellButton;
    Spinner quantitySpinner;
    Spinner priceSpinner;
    Spinner expensesSpinner;
    Text totalText;
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    NumberFormat nf = NumberFormat.getInstance();

    public TransactionDialog(Account account, Shell parentShell) {
        super(parentShell);
        this.account = account;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Transaction");
        this.nf.setGroupingUsed(true);
        this.nf.setMinimumIntegerDigits(1);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validateDialog();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Date / Time");
        label.setLayoutData((Object)new GridData(125, -1));
        this.dateText = new Text(content, 2048);
        this.dateText.setLayoutData((Object)new GridData(125, -1));
        this.dateText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    Date date = TransactionDialog.this.df.parse(TransactionDialog.this.dateText.getText());
                    TransactionDialog.this.dateText.setText(TransactionDialog.this.df.format(date));
                }
                catch (Exception exception) {}
            }
        });
        label = new Label(content, 0);
        label.setText("Account");
        label.setLayoutData((Object)new GridData(125, -1));
        this.accountCombo = new Combo(content, 8);
        this.accountCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.accountCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionDialog.this.updateTotals();
            }
        });
        label = new Label(content, 0);
        label.setText("Security");
        label.setLayoutData((Object)new GridData(125, -1));
        this.securityCombo = new Combo(content, 8);
        this.securityCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.securityCombo.setVisibleItemCount(25);
        this.securityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Security security;
                if (TransactionDialog.this.transaction == null && (security = (Security)TransactionDialog.this.securityCombo.getData(TransactionDialog.this.securityCombo.getText())) != null && security.getQuote() != null) {
                    TransactionDialog.this.priceSpinner.setSelection((int)Math.round(security.getQuote().getLast() * Math.pow(10.0, TransactionDialog.this.priceSpinner.getDigits())));
                    TransactionDialog.this.updateTotals();
                }
                TransactionDialog.this.validateDialog();
            }
        });
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(125, -1));
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        this.buyButton = new Button(group, 16);
        this.buyButton.setText("Buy");
        this.buyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionDialog.this.updateTotals();
            }
        });
        this.sellButton = new Button(group, 16);
        this.sellButton.setText("Sell");
        this.sellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionDialog.this.updateTotals();
            }
        });
        label = new Label(content, 0);
        label.setText("Quantity");
        label.setLayoutData((Object)new GridData(125, -1));
        this.quantitySpinner = new Spinner(content, 2048);
        this.quantitySpinner.setMinimum(1);
        this.quantitySpinner.setMaximum(999999);
        this.quantitySpinner.setSelection(Math.abs(this.defaultQuantity));
        this.quantitySpinner.setLayoutData((Object)new GridData(60, -1));
        this.quantitySpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionDialog.this.updateTotals();
            }
        });
        label = new Label(content, 0);
        label.setText("Price");
        label.setLayoutData((Object)new GridData(125, -1));
        this.priceSpinner = new Spinner(content, 2048);
        this.priceSpinner.setMinimum(0);
        this.priceSpinner.setMaximum(999999999);
        this.priceSpinner.setDigits(4);
        this.priceSpinner.setIncrement(100);
        this.priceSpinner.setSelection(0);
        this.priceSpinner.setLayoutData((Object)new GridData(60, -1));
        this.priceSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionDialog.this.updateTotals();
            }
        });
        label = new Label(content, 0);
        label.setText("Expenses");
        label.setLayoutData((Object)new GridData(125, -1));
        this.expensesSpinner = new Spinner(content, 2048);
        this.expensesSpinner.setMinimum(0);
        this.expensesSpinner.setMaximum(99999999);
        this.expensesSpinner.setDigits(2);
        this.expensesSpinner.setIncrement(1);
        this.expensesSpinner.setSelection(0);
        this.expensesSpinner.setLayoutData((Object)new GridData(60, -1));
        label = new Label(content, 0);
        label.setText("Total");
        label.setLayoutData((Object)new GridData(125, -1));
        this.totalText = new Text(content, 133128);
        this.totalText.setEnabled(false);
        this.totalText.setLayoutData((Object)new GridData(60, -1));
        ObservableList list = CorePlugin.getRepository().allAccounts();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Account)arg0).getDescription().compareTo(((Account)arg1).getDescription());
            }
        });
        for (Account s : list) {
            this.accountCombo.add(s.getDescription());
            this.accountCombo.setData(s.getDescription(), (Object)s);
        }
        if (this.account != null) {
            this.accountCombo.setText(this.account.getDescription());
        }
        list = CorePlugin.getRepository().allSecurities();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Security)arg0).getDescription().compareTo(((Security)arg1).getDescription());
            }
        });
        for (Account s : list) {
            this.securityCombo.add(s.getDescription());
            this.securityCombo.setData(s.getDescription(), (Object)s);
        }
        if (this.transaction != null) {
            this.setTitle("Edit a Transaction");
            this.setMessage("Enter the details of the transaction to edit");
            this.dateText.setText(this.df.format(this.transaction.getDate()));
            this.securityCombo.setText(this.transaction.getSecurity().getDescription());
            this.buyButton.setSelection(this.transaction.getQuantity() >= 0);
            this.sellButton.setSelection(this.transaction.getQuantity() < 0);
            this.quantitySpinner.setSelection(Math.abs(this.transaction.getQuantity()));
            this.priceSpinner.setSelection((int)Math.round(this.transaction.getPrice() * Math.pow(10.0, this.priceSpinner.getDigits())));
            this.expensesSpinner.setSelection((int)Math.round(this.transaction.getExpenses() * Math.pow(10.0, this.expensesSpinner.getDigits())));
        } else {
            this.setTitle("Create a new Transaction");
            this.setMessage("Enter the details of the transaction to create");
            this.dateText.setText(this.df.format(Calendar.getInstance().getTime()));
            this.buyButton.setSelection(this.defaultQuantity >= 0);
            this.sellButton.setSelection(this.defaultQuantity < 0);
            if (this.security != null) {
                this.securityCombo.setText(this.security.getDescription());
                if (this.security.getQuote() != null) {
                    this.priceSpinner.setSelection((int)Math.round(this.security.getQuote().getLast() * Math.pow(10.0, this.priceSpinner.getDigits())));
                }
                this.quantitySpinner.setFocus();
            } else {
                this.securityCombo.setFocus();
            }
        }
        this.updateTotals();
        this.dateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransactionDialog.this.validateDialog();
            }
        });
        return super.createDialogArea(parent);
    }

    public int open(Transaction transaction) {
        this.transaction = transaction;
        this.security = transaction.getSecurity();
        return super.open();
    }

    public int open(Security security) {
        this.security = security;
        return super.open();
    }

    protected void okPressed() {
        if (this.transaction != null) {
            this.account.getTransactions().remove((Object)this.transaction);
        }
        this.transaction = new Transaction();
        this.transaction.setDate(Calendar.getInstance().getTime());
        try {
            this.transaction.setDate(this.df.parse(this.dateText.getText()));
        }
        catch (Exception e) {
            CorePlugin.logException((Exception)e);
        }
        this.transaction.setSecurity((Security)this.securityCombo.getData(this.securityCombo.getText()));
        if (this.buyButton.getSelection()) {
            this.transaction.setQuantity(this.quantitySpinner.getSelection());
        } else {
            this.transaction.setQuantity(-this.quantitySpinner.getSelection());
        }
        this.transaction.setPrice((double)this.priceSpinner.getSelection() / Math.pow(10.0, this.priceSpinner.getDigits()));
        this.transaction.setExpenses((double)this.expensesSpinner.getSelection() / Math.pow(10.0, this.expensesSpinner.getDigits()));
        this.account.getTransactions().add((Object)this.transaction);
        CorePlugin.getRepository().save((PersistentObject)this.account);
        super.okPressed();
    }

    void updateTotals() {
        int quantity = this.quantitySpinner.getSelection();
        double price = (double)this.priceSpinner.getSelection() / Math.pow(10.0, this.priceSpinner.getDigits());
        double total = (double)quantity * price;
        double expenses = this.account.getExpenses((Security)this.securityCombo.getData(this.securityCombo.getText()), quantity, price);
        if (this.transaction != null) {
            expenses = this.transaction.getExpenses();
        } else {
            this.expensesSpinner.setSelection((int)Math.round(expenses * Math.pow(10.0, this.expensesSpinner.getDigits())));
        }
        total = this.buyButton.getSelection() ? (total += expenses) : (total -= expenses);
        this.totalText.setText(this.nf.format(total));
    }

    public void setDefaultQuantity(int defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
    }

    void validateDialog() {
        boolean enable = true;
        this.setErrorMessage(null);
        try {
            this.df.parse(this.dateText.getText());
        }
        catch (Exception exception) {
            this.setErrorMessage("Invalid date and time format");
            enable = false;
        }
        if (this.securityCombo.getSelectionIndex() == -1) {
            this.setErrorMessage("Select a security");
            enable = false;
        }
        if (this.priceSpinner.getSelection() == 0) {
            this.setErrorMessage("Enter a price");
            enable = false;
        }
        this.getButton(0).setEnabled(enable);
    }
}

