/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.OrderMessage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.NumberVerifyListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class TradeDialog
extends Dialog {
    NumberVerifyListener numberVerifier = new NumberVerifyListener();
    PriceVerifyListener priceVerifier = new PriceVerifyListener();
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();
    private NumberFormat numberFormatter = CorePlugin.getNumberFormatter();
    Composite parent;
    Label symbolName;
    Text txtClientCode;
    Text txtPin;
    Text txtPrice;
    Text txtVolume;
    Security security;
    public static Button btnBuy;
    public static Button btnSell;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FontMetrics fontMetrics;

    public TradeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Trade");
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(112);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Display device = Display.getCurrent();
        Color pink = new Color((Device)device, 0, 153, 0);
        Color green = new Color((Device)device, 255, 128, 0);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 10;
        layout.marginBottom = 10;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        composite.setLayout((Layout)layout);
        GridData gdText = new GridData(4, 1024, true, false);
        gdText.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)20);
        Font font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.symbolName = new Label(composite, 1);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.symbolName);
        this.symbolName.setFont(font_bold);
        this.symbolName.setForeground(green);
        Label lblvolume = new Label(composite, 0);
        lblvolume.setText("Volume");
        lblvolume.setAlignment(16384);
        lblvolume.setForeground(pink);
        Label lblprice = new Label(composite, 0);
        lblprice.setText("Price");
        lblprice.setAlignment(16384);
        lblprice.setForeground(pink);
        Label lblaccount = new Label(composite, 0);
        lblaccount.setText("Account");
        lblaccount.setAlignment(16384);
        lblaccount.setForeground(pink);
        this.txtVolume = new Text(composite, 2048);
        this.txtVolume.setLayoutData((Object)gdText);
        this.txtVolume.addVerifyListener((VerifyListener)this.numberVerifier);
        this.txtPrice = new Text(composite, 2048);
        this.txtPrice.setLayoutData((Object)gdText);
        this.txtPrice.addVerifyListener((VerifyListener)this.priceVerifier);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)gdText);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        Composite comButton = new Composite(parent, 0x1000008);
        comButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        comButton.setLayout((Layout)new GridLayout(2, true));
        GridData gdButton = new GridData(16384, 1024, true, false);
        gdButton.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15);
        btnBuy = new Button(comButton, 8);
        btnBuy.setText("BUY");
        btnBuy.setLayoutData((Object)gdButton);
        btnBuy.setForeground(new Color((Device)device, 0, 0, 0));
        btnBuy.setBackground(new Color((Device)device, 153, 204, 255));
        btnBuy.setEnabled(false);
        btnBuy.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        TradeDialog.this.sendOrder("buy");
                    }
                }
            }
        });
        btnSell = new Button(comButton, 8);
        btnSell.setText("SELL");
        btnSell.setLayoutData((Object)gdButton);
        btnSell.setForeground(new Color((Device)device, 0, 0, 0));
        btnSell.setBackground(new Color((Device)device, 255, 204, 204));
        btnSell.setEnabled(false);
        btnSell.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        TradeDialog.this.sendOrder("sell");
                    }
                }
            }
        });
        TradeDialog.enableButton();
        return super.createDialogArea(parent);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public boolean close() {
        return super.close();
    }

    protected void okPressed() {
    }

    public void setSecurity(Security newSecurity, String type) {
        this.security = newSecurity;
        try {
            if (newSecurity != null) {
                if (newSecurity.getQuote() != null) {
                    this.symbolName.setText(String.valueOf(newSecurity.getSymbol()) + " ( " + newSecurity.getDescription() + " ) ");
                    this.txtVolume.setText("0");
                    if (type.equalsIgnoreCase("buy")) {
                        this.txtPrice.setText(this.priceFormatter.format(newSecurity.getQuote().getAsk()).replaceAll(",", ""));
                    } else if (type.equalsIgnoreCase("sell")) {
                        this.txtPrice.setText(this.priceFormatter.format(newSecurity.getQuote().getBid()).replaceAll(",", ""));
                    }
                }
                if (Resources.isClientType()) {
                    this.txtClientCode.setText(Resources.clientId);
                } else {
                    this.txtClientCode.setText(TradingPlugin.getDefault().getPreferenceStore().getString(TradingPlugin.PREFS_ORDER_VIEW_CLIENT_CODE));
                }
                this.txtClientCode.setEnabled(!Resources.isClientType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int open(Security security, String type) {
        this.create();
        this.setSecurity(security, type);
        return super.open();
    }

    public void sendOrder(String ty) {
        final String type = ty;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block39: {
                    block37: {
                        if (!Resources.isServerConnected((String)TradeDialog.this.txtClientCode.getText(), (boolean)true, (boolean)false)) break block39;
                        valid = true;
                        sendMessage = true;
                        values = new String[5];
                        action = 0;
                        orderSide = -1;
                        memberId = Resources.memberId;
                        sTraderId = Resources.traderId;
                        expiryDate = Resources.systemDate;
                        symbol = "";
                        orderVolume = 0;
                        orderPrice = 0.0f;
                        buyClientAcc = TradeDialog.this.txtClientCode.getText();
                        buyOrderNumber = 0;
                        sellClientAcc = TradeDialog.this.txtClientCode.getText();
                        sellOrderNumber = 0;
                        oldPrice = 0.0f;
                        remainingVolume = 0;
                        oldVolume = 0;
                        orderType = -1;
                        orderProperty = -1;
                        refNumber = "";
                        discloseVolume = 0;
                        triggerPrice = 0.0f;
                        exchangeCode = "";
                        marketTypeCode = "";
                        afterHour = 0;
                        gtc = 0;
                        TradeDialog.access$0(TradeDialog.this).info((Object)"**************************** ORDER INFO START ****************************");
                        try {
                            if (TradeDialog.this.txtClientCode.getText().equals("") || TradeDialog.this.txtClientCode.getText().equals(null)) {
                                valid = false;
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Account code is not entered.");
                                TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid client code");
                                return;
                            }
                        }
                        catch (Exception e0) {
                            valid = false;
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Account code is not entered.");
                            TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid client code" + e0.getMessage()));
                            return;
                        }
                        try {
                            symbol = TradeDialog.this.security.getSymbol();
                            if (symbol == null) {
                                valid = false;
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Enter a valid symbol.");
                                TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid order symbol");
                                return;
                            }
                            ** GOTO lbl57
                        }
                        catch (Exception e1) {
                            valid = false;
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Enter a valid symbol.");
                            TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid order symbol " + e1.getMessage()));
                            return;
lbl57:
                            // 1 sources

                            try {
                                orderVolume = Integer.parseInt(TradeDialog.this.txtVolume.getText());
                                remainingVolume = Integer.parseInt(TradeDialog.this.txtVolume.getText());
                                if (orderVolume <= 0) {
                                    valid = false;
                                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Invalid order volume.");
                                    TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid order volume");
                                    return;
                                }
                                ** GOTO lbl72
                            }
                            catch (Exception e2) {
                                valid = false;
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Invalid order volume.");
                                TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid order volume" + e2.getMessage()));
                                return;
lbl72:
                                // 1 sources

                                try {
                                    orderPrice = Float.parseFloat(TradeDialog.this.txtPrice.getText());
                                    if (orderPrice <= 0.0f) {
                                        valid = false;
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Invalid order price.");
                                        TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid order price");
                                        return;
                                    }
                                    ** GOTO lbl86
                                }
                                catch (Exception e1) {
                                    valid = false;
                                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid Order:", (String)"Invalid order price.");
                                    TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid order price" + e1.getMessage()));
                                    return;
lbl86:
                                    // 1 sources

                                    try {
                                        orderType = (Integer)Resources.orderTypeCodes.get(Resources.orderTypes.indexOf("LIMIT"));
                                        if (orderType < 0) {
                                            valid = false;
                                            TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid order type");
                                            return;
                                        }
                                        ** GOTO lbl98
                                    }
                                    catch (Exception e1) {
                                        valid = false;
                                        TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid order type " + e1.getMessage()));
                                        return;
lbl98:
                                        // 1 sources

                                        try {
                                            orderProperty = (Integer)Resources.orderPropertyCodes.get(Resources.orderProperties.indexOf("NONE"));
                                            if (orderProperty < 0) {
                                                valid = false;
                                                TradeDialog.access$0(TradeDialog.this).info((Object)"Invalid order property");
                                                return;
                                            }
                                            ** GOTO lbl110
                                        }
                                        catch (Exception e1) {
                                            try {
                                                valid = false;
                                                TradeDialog.access$0(TradeDialog.this).info((Object)("Invalid order property " + e1.getMessage()));
                                                return;
lbl110:
                                                // 1 sources

                                                try {
                                                    marketTypeCode = Resources.marketTypeCodes.get(Resources.marketTypes.indexOf(TradeDialog.this.security.getMarket())).toString();
                                                    exchangeCode = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(TradeDialog.this.security.getExchange())).toString();
                                                }
                                                catch (Exception v0) {
                                                    valid = false;
                                                }
                                                TradeDialog.access$0(TradeDialog.this).info((Object)("ORDER DATA VALID FLAG  = " + valid));
                                                if (!valid) break block37;
                                                if (type.equals("buy")) {
                                                    values[0] = "Buy";
                                                    values[1] = symbol;
                                                    values[2] = TradeDialog.access$1(TradeDialog.this).format(orderVolume);
                                                    values[3] = TradeDialog.access$2(TradeDialog.this).format(orderPrice);
                                                    values[4] = TradeDialog.access$2(TradeDialog.this).format(orderPrice * (float)orderVolume);
                                                    if (TradingPlugin.getDefault().pinCodeValidation("Are you sure you want to Buy " + TradeDialog.this.txtVolume.getText() + " " + symbol + " at " + TradeDialog.this.txtPrice.getText() + " ?", values)) {
                                                        action = 0;
                                                        orderSide = 0;
                                                        sellClientAcc = "";
                                                    } else {
                                                        sendMessage = false;
                                                    }
                                                } else if (type.equals("sell")) {
                                                    values[0] = "Sell";
                                                    values[1] = symbol;
                                                    values[2] = TradeDialog.access$1(TradeDialog.this).format(orderVolume);
                                                    values[3] = TradeDialog.access$2(TradeDialog.this).format(orderPrice);
                                                    values[4] = TradeDialog.access$2(TradeDialog.this).format(orderPrice * (float)orderVolume);
                                                    if (TradingPlugin.getDefault().pinCodeValidation("Are you sure you want to Sell " + TradeDialog.this.txtVolume.getText() + " " + symbol + " at " + TradeDialog.this.txtPrice.getText() + " ?", values)) {
                                                        action = 0;
                                                        orderSide = 1;
                                                        buyClientAcc = "";
                                                    } else {
                                                        sendMessage = false;
                                                    }
                                                }
                                                TradeDialog.access$0(TradeDialog.this).info((Object)("FORM TITLE = " + type));
                                                TradeDialog.access$0(TradeDialog.this).info((Object)("SEND MESSAGE FLAG =  " + sendMessage));
                                                if (!sendMessage) break block37;
                                                orderMsg = new OrderMessage(Resources.userId, action, 0, marketTypeCode, symbol, memberId, sTraderId, orderPrice, oldPrice, triggerPrice, expiryDate, buyClientAcc, buyOrderNumber, sellClientAcc, sellOrderNumber, orderProperty, orderType, orderVolume, remainingVolume, discloseVolume, orderSide, refNumber, oldVolume, afterHour, gtc);
                                                orderMsg.setStExCode(exchangeCode);
                                                orderMsg.setClientUIN("");
                                                orderMsg.setByPassMargin(false);
                                                TradeDialog.access$0(TradeDialog.this).info((Object)(String.valueOf(Resources.getServerTime().toString()) + " sending order " + exchangeCode + "." + marketTypeCode + "." + symbol + " at " + orderVolume + "," + orderPrice));
                                                try {
                                                    Resources.orderConfRecieved = false;
                                                    if (Resources.getServerLink((String)TradeDialog.this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)orderMsg)) {
                                                        TradeDialog.access$0(TradeDialog.this).debug((Object)("order sent >> " + orderMsg.formatString()));
                                                        orderMsg = null;
                                                        TradeDialog.btnBuy.setEnabled(false);
                                                        TradeDialog.btnSell.setEnabled(false);
                                                        TradeDialog.this.txtVolume.setText("0");
                                                        TradeDialog.this.txtClientCode.setText("");
                                                    }
                                                }
                                                catch (Exception e) {
                                                    CorePlugin.logException((Exception)e);
                                                }
                                            }
                                            catch (Exception e) {
                                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Order Sending Failed", (String)("Invalid Information " + e.getMessage()));
                                                TradeDialog.access$0(TradeDialog.this).error((Object)e, (Throwable)e);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    TradeDialog.access$0(TradeDialog.this).info((Object)"************************ ORDER INFO END ****************************");
                }
            }
        });
    }

    public static void enableButton() {
        if (Resources.buyOrderOption) {
            btnBuy.setEnabled(true);
        }
        if (Resources.sellOrderOption) {
            btnSell.setEnabled(true);
        }
    }

    static /* synthetic */ Log access$0(TradeDialog tradeDialog) {
        return tradeDialog.logger;
    }

    static /* synthetic */ NumberFormat access$1(TradeDialog tradeDialog) {
        return tradeDialog.numberFormatter;
    }

    static /* synthetic */ NumberFormat access$2(TradeDialog tradeDialog) {
        return tradeDialog.priceFormatter;
    }
}

