/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.History;

public class TestPeriodDialog
extends Dialog {
    private Combo begin;
    private Combo end;
    private History history;
    private static Date beginDate;
    private static Date endDate;

    public TestPeriodDialog(Shell parentShell, History history) {
        super(parentShell);
        this.history = history;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Simulation Period");
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Begin Date");
        this.begin = new Combo(content, 8);
        this.begin.setVisibleItemCount(25);
        label = new Label(content, 0);
        label.setText("End Date");
        this.end = new Combo(content, 8);
        this.end.setVisibleItemCount(25);
        int first = -1;
        int last = -1;
        SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
        int i = 0;
        while (i < this.history.size()) {
            Bar bar = this.history.get(i);
            this.begin.add(dateFormat.format(bar.getDate()));
            this.end.add(dateFormat.format(bar.getDate()));
            if (first == -1 && beginDate != null && (bar.getDate().equals(beginDate) || bar.getDate().after(beginDate))) {
                first = i;
            }
            if (last == -1 && endDate != null && (bar.getDate().equals(endDate) || bar.getDate().after(endDate))) {
                last = i;
            }
            ++i;
        }
        this.begin.select(first != -1 ? first : 0);
        this.end.select(last != -1 ? last : this.end.getItemCount() - 1);
        return content.getParent();
    }

    protected void okPressed() {
        beginDate = this.history.get(this.begin.getSelectionIndex()).getDate();
        endDate = this.history.get(this.end.getSelectionIndex()).getDate();
        super.okPressed();
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }
}

