/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.util.Date;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.SecuritySelection;
import pk.com.softech.tradingterminal.trading.dialogs.PatternSearchDialog;
import pk.com.softech.tradingterminal.trading.internal.SecurityPatternsSearchPage;
import pk.com.softech.tradingterminal.trading.views.PatternSearchView;

public class SecurityPatternSearchDialog
extends PatternSearchDialog {
    private Combo securities;

    public SecurityPatternSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    public SecurityPatternSearchDialog(IViewPart view) {
        super(view);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        ISelection selection;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Security");
        label.setLayoutData((Object)new GridData(125, -1));
        this.securities = new Combo(content, 8);
        this.securities.setLayoutData((Object)new GridData(4, 1, true, false));
        for (Security security : CorePlugin.getRepository().allSecurities()) {
            this.securities.add(security.getDescription());
            this.securities.setData(security.getDescription(), (Object)security);
        }
        this.securities.select(0);
        if (this.view != null && this.view.getViewSite().getSelectionProvider() != null && (selection = this.view.getViewSite().getSelectionProvider().getSelection()) instanceof SecuritySelection) {
            this.securities.setText(((SecuritySelection)selection).getSecurity().getDescription());
        }
        return super.createDialogArea(content);
    }

    @Override
    public void okPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            PatternSearchView view = (PatternSearchView)page.showView("pk.com.softech.tradingterminal.patternSearch");
            Security security = (Security)this.securities.getData(this.securities.getText());
            int period = 8;
            switch (this.period.getSelectionIndex()) {
                case 0: {
                    period = 8;
                    break;
                }
                case 1: {
                    period = 9;
                    break;
                }
                case 2: {
                    period = 10;
                }
            }
            Date beginDate = null;
            Date endDate = null;
            try {
                if (this.begin.getText().length() != 0) {
                    beginDate = this.dateParse.parse(this.begin.getText());
                }
                if (this.end.getText().length() != 0) {
                    endDate = this.dateParse.parse(this.end.getText());
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
            SecurityPatternsSearchPage searchPage = null;
            if (this.pattern.getData(this.pattern.getText()) != null) {
                IPattern plugin = CorePlugin.createPatternPlugin((String)((String)this.pattern.getData(this.pattern.getText())));
                searchPage = new SecurityPatternsSearchPage(security, plugin, this.pattern.getText(), period, beginDate, endDate, this.bullishOnly.getSelection());
            } else {
                searchPage = new SecurityPatternsSearchPage(security, period, beginDate, endDate, this.bullishOnly.getSelection());
            }
            searchPage.setAllOccurrences(this.allOccurrences.getSelection());
            view.addPage(searchPage);
        }
        catch (Exception e) {
            CorePlugin.logException((Exception)e);
        }
        super.okPressed();
    }
}

