/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.SectorPerformanceData;
import pk.com.softech.messages.SectorPerformanceRequest;
import pk.com.softech.messages.SectorPerformanceResponse;
import pk.com.softech.messages.WatchlistData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.QuoteRequestView;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;

public class SectorPerformanceDialog
extends Dialog
implements ICollectionObserver {
    private Composite parent;
    private Composite content;
    private TableViewer viewer;
    private Table table;
    private WatchlistView watchlistView;
    private Watchlist watchlist;
    String viewID;
    int selection;
    Label totalSectors;
    List<WatchlistData> list = Resources.sectorWatch.getSubWatches();
    public static final int SECTOR_NAME = 0;
    public static final int TOTAL_VOLUME = 1;
    public static final int LEADER = 2;
    public static final int LEADER_VOLUME = 3;
    private static String[] COLUMN_NAMES = new String[]{"Sector Name(s)", "Total Volume", "Leader(s)", "Leader(s) Volume"};
    public static final String PREFS_SORT_COLUMN = "CLIENTLISTING_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "CLIENTLISTING_SORT_DIRECTION";
    public static final String PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE = "PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE";
    private NumberFormat formatter = CorePlugin.getNumberFormatter();

    public SectorPerformanceDialog(Shell parentShell, String viewID, int selection) {
        super(parentShell);
        this.viewID = viewID;
        this.selection = selection;
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(container, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        this.createViewer(this.content);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite c1 = new Composite(composite, 0);
        c1.setLayout((Layout)new GridLayout(1, true));
        c1.setLayoutData((Object)new GridData(16384, 16384, true, false));
        this.totalSectors = new Label(c1, 0);
        this.totalSectors.setText("              ");
        this.totalSectors.setLayoutData((Object)new GridData(100, 25));
        Composite c2 = new Composite(composite, 0);
        c2.setLayout((Layout)new GridLayout(1, true));
        c2.setLayoutData((Object)new GridData(131072, 131072, true, false));
        Image img = TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif").createImage();
        Button refresh = new Button(c2, 0);
        refresh.setImage(img);
        refresh.setText("Refresh");
        refresh.setLayoutData((Object)new GridData(100, 25));
        refresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SectorPerformanceDialog.this.sendSectorPerformanceRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.loginStatus) {
            this.sendSectorPerformanceRequest();
        }
        return container;
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    protected void okPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.okPressed();
    }

    public void recieveSectorPerformanceResponse(final SectorPerformanceResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (resp.getRows() != null) {
                            System.out.println("Length : " + resp.getRows().length);
                            SectorPerformanceDialog.this.totalSectors.setText(String.valueOf(resp.getRows().length) + " sectors");
                            SectorPerformanceDialog.this.viewer.setInput(Arrays.asList(resp.getRows()));
                            SectorPerformanceDialog.this.viewer.refresh();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void sendSectorPerformanceRequest() {
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                System.out.println("Sectors Request Sent");
                SectorPerformanceRequest request = new SectorPerformanceRequest();
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, this.selection | 0x100 | 0x200 | 0x10000 | 0x800);
        this.createColumns(parent, this.viewer);
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SectorPerformanceDialog.this.table.getItem(new Point(e.x, e.y)) == null) {
                    SectorPerformanceDialog.this.table.deselectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                block11: {
                    try {
                        TableColumn column = SectorPerformanceDialog.this.getColumn(e);
                        if (column != null && column.getText().equalsIgnoreCase("Sector Name(s)")) {
                            TableItem[] item = SectorPerformanceDialog.this.table.getSelection();
                            if (item.length == 1) {
                                SectorPerformanceData data = (SectorPerformanceData)item[0].getData();
                                if (data != null) {
                                    for (WatchlistData item1 : SectorPerformanceDialog.this.list) {
                                        if (!data.getSectorName().trim().contains(item1.getName().trim())) continue;
                                        SectorPerformanceDialog.this.watchlist = (Watchlist)CorePlugin.getRepository().load(Watchlist.class, item1.getId());
                                        break;
                                    }
                                }
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                try {
                                    page.showView("pk.com.softech.tradingterminal.trading.watchlist", String.valueOf(SectorPerformanceDialog.this.watchlist.getId()), 1);
                                }
                                catch (PartInitException e1) {
                                    CorePlugin.logException((Exception)((Object)e1));
                                }
                            }
                            break block11;
                        }
                        if (column == null || !column.getText().equalsIgnoreCase("Leader(s)")) break block11;
                        Security security = null;
                        TableItem[] item = SectorPerformanceDialog.this.table.getSelection();
                        if (item.length != 1) break block11;
                        SectorPerformanceData data = (SectorPerformanceData)item[0].getData();
                        security = CorePlugin.getRepository().getSecurity(data.getSymbol().toUpperCase());
                        try {
                            QuoteRequestView view = (QuoteRequestView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.quoteRequest");
                            if (security != null) {
                                view.setSecurity(security);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Exception exx) {
                        exx.printStackTrace();
                    }
                }
            }
        });
    }

    protected TableColumn getColumn(MouseEvent e) {
        try {
            Point p = new Point(e.x, e.y);
            TableItem item = this.table.getItem(p);
            if (item != null) {
                int i = 0;
                while (i < this.table.getColumnCount()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(p)) {
                        TableColumn column = this.table.getColumn(i);
                        return column;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            this.createTableViewerColumn(i);
            ++i;
        }
        viewer.getTable().getColumn(0).setWidth(170);
        viewer.getTable().getColumn(1).setWidth(100);
        viewer.getTable().getColumn(2).setWidth(100);
        viewer.getTable().getColumn(3).setWidth(120);
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                try {
                    switch (colNumber) {
                        case 0: {
                            cell.setText(((SectorPerformanceData)cell.getElement()).getSectorName().toUpperCase());
                            break;
                        }
                        case 1: {
                            cell.setText(SectorPerformanceDialog.this.formatter.format(((SectorPerformanceData)cell.getElement()).getTotalTurnover()));
                            break;
                        }
                        case 2: {
                            cell.setText(((SectorPerformanceData)cell.getElement()).getSymbol().toUpperCase());
                            break;
                        }
                        case 3: {
                            cell.setText(SectorPerformanceDialog.this.formatter.format(((SectorPerformanceData)cell.getElement()).getTurnover()));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public String getToolTipText(Object element) {
                SectorPerformanceData sec = (SectorPerformanceData)element;
                return sec.getSectorName();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Sector Performance Window");
        newShell.setSize(550, 400);
        newShell.setLocation(480, 250);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof SectorPerformanceResponse) {
                        SectorPerformanceResponse rsp = (SectorPerformanceResponse)o;
                        SectorPerformanceDialog.this.recieveSectorPerformanceResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }
}

