/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import pk.com.softech.tradingterminal.trading.views.IPatternSearchPage;

public class SearchPageSelectionDialog
extends Dialog {
    private List pages;
    private Table table;
    private IPatternSearchPage selectedPage;

    public SearchPageSelectionDialog(Shell parentShell, List pages, IPatternSearchPage selectedPage) {
        super(parentShell);
        this.pages = pages;
        this.selectedPage = selectedPage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Search Page Selection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(content, 65540);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 250;
        gridData.heightHint = 250;
        this.table.setLayoutData((Object)gridData);
        new TableColumn(this.table, 16384);
        for (IPatternSearchPage page : this.pages) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, page.getShortDescription());
            tableItem.setData((Object)page);
            if (page != this.selectedPage) continue;
            this.table.select(this.table.indexOf(tableItem));
        }
        this.table.getColumn(0).pack();
        return super.createDialogArea(parent);
    }

    protected void okPressed() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 1) {
            this.selectedPage = (IPatternSearchPage)selection[0].getData();
        }
        super.okPressed();
    }

    public IPatternSearchPage getSelectedPage() {
        return this.selectedPage;
    }
}

