/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.net.URL;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.BypassPasswordRequest;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.dialogs.ForgetPinDialog;
import pk.com.softech.tradingterminal.trading.views.OrderFormView;
import pk.com.softech.tradingterminal.trading.wizards.ChangePinCodeDlg;
import pk.com.softech.tradingterminal.trading.wizards.ChangePinCodeWizard;

public class PinCodeVerificationDialog
extends Dialog {
    private Label lblMessage;
    private Label lblPinCode;
    private Text txtPinCode;
    private Button btnSavePinCode;
    private Label lblPassword;
    private Text txtPassword;
    private FontMetrics fontMetrics;
    Log logger = LogFactory.getLog((String)PinCodeVerificationDialog.class.getName());
    private String title = "Send Order Confirmation";
    private String message;
    private Button btnOK;
    private Button btnCancel;
    private String[] order = null;
    private boolean passwordRequired = false;

    public PinCodeVerificationDialog(Shell parentShell, String message, String[] order) {
        super(parentShell);
        this.message = message;
        this.order = order;
        this.passwordRequired = order != null && (order[0].equals("Buy (By-Pass)") || order[0].equals("Short Sell (By-Pass)"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.pinCodeValidation()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Resources.isPinCodeRequired() && PinCodeVerificationDialog.this.txtPinCode.getText().equals(Resources.pinCode) || !Resources.isPinCodeRequired()) {
                            PinCodeVerificationDialog.this.savePreferences();
                            if (PinCodeVerificationDialog.this.passwordRequired) {
                                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                                    Resources.respBypassPwd = null;
                                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new BypassPasswordRequest(Resources.userId, PinCodeVerificationDialog.this.txtPassword.getText()));
                                    BusyIndicator.showWhile((Display)PinCodeVerificationDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            long timeout = new Date().getTime();
                                            while (Resources.respBypassPwd == null && timeout + 5000L > new Date().getTime()) {
                                                try {
                                                    Thread.sleep(200L);
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (Resources.respBypassPwd == null || !Resources.respBypassPwd.isValidate()) {
                                                MessageDialog.openError((Shell)PinCodeVerificationDialog.this.getShell(), (String)"Password Error", (String)(Resources.respBypassPwd == null ? "Invalid By-Pass password." : Resources.respBypassPwd.getMessage()));
                                                PinCodeVerificationDialog.this.txtPassword.forceFocus();
                                            } else {
                                                PinCodeVerificationDialog.this.setReturnCode(0);
                                                PinCodeVerificationDialog.this.close();
                                            }
                                        }
                                    });
                                }
                            } else {
                                PinCodeVerificationDialog.this.setReturnCode(0);
                                PinCodeVerificationDialog.this.close();
                            }
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Pin Code Error", (String)"Invalid Pin Code.");
                            PinCodeVerificationDialog.this.txtPinCode.forceFocus();
                        }
                    }
                });
            } else {
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    private void savePreferences() {
        if (Resources.isPinCodeRequired()) {
            if (this.btnSavePinCode.getSelection()) {
                TradingPlugin.getDefault().getPreferenceStore().setValue("PIN_CODE", this.txtPinCode.getText());
            } else {
                TradingPlugin.getDefault().getPreferenceStore().setValue("PIN_CODE", "");
            }
            TradingPlugin.getDefault().getPreferenceStore().setValue("SAVE_PIN_CODE", this.btnSavePinCode.getSelection());
        }
    }

    protected void okPressed() {
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label lbl = new Label(parent, 0);
        if (this.order != null) {
            lbl.setText("Do you want to send this Order?                                           ");
        } else {
            lbl.setText("                                                                          ");
        }
        this.btnOK = this.createButton(parent, 0, "Send  ", true);
        this.btnCancel = this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (this.order == null) {
            this.lblMessage = new Label(composite, 0);
            this.lblMessage.setText(this.message);
            this.lblMessage.setFont(JFaceResources.getHeaderFont());
            this.lblMessage.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        } else {
            this.createOrderValues(composite);
        }
        if (Resources.isPinCodeRequired()) {
            Group gpPinCode = new Group(composite, 16);
            gpPinCode.setText("Pin Code");
            gpPinCode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
            gpPinCode.setLayout((Layout)new GridLayout(3, false));
            this.lblPinCode = new Label((Composite)gpPinCode, 0);
            this.lblPinCode.setText("Enter Pin Code");
            this.lblPinCode.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.txtPinCode = new Text((Composite)gpPinCode, 0x400800);
            this.txtPinCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
            this.txtPinCode.setTextLimit(4);
            this.txtPinCode.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    PinCodeVerificationDialog.this.txtPinCode.selectAll();
                }
            });
            this.txtPinCode.forceFocus();
            this.btnSavePinCode = new Button((Composite)gpPinCode, 32);
            this.btnSavePinCode.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.btnSavePinCode.setSelection(TradingPlugin.getDefault().getPreferenceStore().getBoolean("SAVE_PIN_CODE"));
            this.btnSavePinCode.setText("Remember Me");
            Link link = new Link(composite, 0);
            if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT || Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
                link.setText("<a>Forgot Pin?</a>");
            }
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PinCodeVerificationDialog.this.cancelPressed();
                    if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT || Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
                        ForgetPinDialog dlg = new ForgetPinDialog(null);
                        dlg.open();
                    } else if (Resources.PRODUCT_NAME == ProductNames.IBROKER) {
                        try {
                            String url = "http://iterminal.calbrokersghana.com:7878/webterminal/forgot_password.html";
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                        }
                        catch (Exception e) {
                            PinCodeVerificationDialog.this.logger.info((Object)("Exception in Forget Password Link : " + e.getMessage()));
                        }
                    }
                }
            });
            if (this.btnSavePinCode.getSelection()) {
                this.txtPinCode.setText(TradingPlugin.getDefault().getPreferenceStore().getString("PIN_CODE"));
            }
        }
        if (this.passwordRequired) {
            Group gpPassword = new Group(composite, 16);
            gpPassword.setText("Password");
            gpPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            gpPassword.setLayout((Layout)new GridLayout(2, false));
            this.lblPassword = new Label((Composite)gpPassword, 0);
            this.lblPassword.setText("Enter Password");
            this.lblPassword.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.txtPassword = new Text((Composite)gpPassword, 0x400800);
            this.txtPassword.setLayoutData((Object)new GridData(90, 16));
            this.txtPassword.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    PinCodeVerificationDialog.this.txtPassword.selectAll();
                }
            });
        }
        PinCodeVerificationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createOrderValues(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(5, true));
        content.setLayoutData((Object)new GridData(1808, 2, false, false, 5, 1));
        new Label(content, 0).setText("Action");
        new Label(content, 0).setText("Symbol");
        new Label(content, 0).setText("Volume");
        new Label(content, 0).setText("Price");
        new Label(content, 0).setText("Estimated Value");
        Label[] lblArr = new Label[5];
        lblArr[0] = new Label(content, 0);
        lblArr[0].setText(this.order[0]);
        lblArr[1] = new Label(content, 0);
        lblArr[1].setText(this.order[1]);
        lblArr[2] = new Label(content, 0);
        lblArr[2].setText(this.order[2]);
        lblArr[3] = new Label(content, 0);
        lblArr[3].setText(this.order[3]);
        lblArr[4] = new Label(content, 0);
        lblArr[4].setText(this.order[4]);
        Color color = new Color((Device)Display.getDefault(), 255, 0, 0);
        if (this.order[0].equals("Buy")) {
            color = new Color((Device)Display.getDefault(), 0, 128, 0);
        } else if (this.order[0].equals("Buy (By-Pass)")) {
            color = OrderFormView.buyBPBackground;
        } else if (this.order[0].equals("Sell")) {
            color = new Color((Device)Display.getDefault(), 255, 0, 0);
        } else if (this.order[0].equals("Short Sell")) {
            color = new Color((Device)Display.getDefault(), 255, 0, 0);
        } else if (this.order[0].equals("Short Sell (By-Pass)")) {
            color = OrderFormView.shortSellBPBackground;
        } else if (this.order[0].equals("Modify")) {
            color = OrderFormView.editBackground;
        } else if (this.order[0].equals("Cancel")) {
            color = OrderFormView.cancelBackground;
        }
        if (color != null) {
            int i = 0;
            while (i < lblArr.length) {
                lblArr[i].setForeground(color);
                ++i;
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        ((GridData)composite.getLayoutData()).horizontalAlignment = 64;
        return composite;
    }

    private boolean pinCodeValidation() {
        block6: {
            block7: {
                if (!Resources.isPinCodeRequired()) break block6;
                if (!this.txtPinCode.getText().equals("")) break block7;
                MessageDialog.openError(null, (String)this.title, (String)"Please enter your Pin Code.");
                this.txtPinCode.forceFocus();
                return false;
            }
            if (!Resources.changePincode) break block6;
            MessageDialog.openError(null, (String)this.title, (String)"Please change your Pin Code first.");
            ChangePinCodeDlg dialog = new ChangePinCodeDlg(Display.getCurrent().getActiveShell(), (IWizard)new ChangePinCodeWizard());
            dialog.setBlockOnOpen(true);
            int ret = dialog.open();
            if (ret == 0) {
                this.txtPinCode.setText("");
            }
            return false;
        }
        try {
            if (this.passwordRequired && this.txtPassword.getText().equals("")) {
                MessageDialog.openError(null, (String)this.title, (String)"Please enter your Password.");
                this.txtPassword.forceFocus();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

