/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;

public abstract class PatternSearchDialog
extends Dialog {
    protected IViewPart view;
    protected Combo period;
    protected Combo pattern;
    protected Button bullishOnly;
    protected Text begin;
    protected Text end;
    protected Button allOccurrences;
    protected SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
    protected SimpleDateFormat dateParse = CorePlugin.getDateParse();
    protected static Map last = new HashMap();

    public PatternSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    public PatternSearchDialog(IViewPart view) {
        super(view.getViewSite().getShell());
        this.view = view;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Pattern Search");
    }

    protected Control createDialogArea(Composite content) {
        Label label = new Label(content, 0);
        label.setText("Pattern");
        label.setLayoutData((Object)new GridData(125, -1));
        this.pattern = new Combo(content, 8);
        this.pattern.setLayoutData((Object)new GridData(4, 1, true, false));
        this.pattern.add("All");
        for (IConfigurationElement element : CorePlugin.getAllPatternPlugins()) {
            this.pattern.add(element.getAttribute("name"));
            this.pattern.setData(element.getAttribute("name"), (Object)element.getAttribute("id"));
        }
        if (last.get("pattern") != null) {
            this.pattern.setText((String)last.get("pattern"));
        } else {
            this.pattern.select(0);
        }
        label = new Label(content, 0);
        label.setText("Begin Date");
        label.setLayoutData((Object)new GridData(125, -1));
        this.begin = new Text(content, 2048);
        this.begin.setLayoutData((Object)new GridData(80, -1));
        this.begin.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (PatternSearchDialog.this.begin.getText().length() != 0) {
                    try {
                        Date date = PatternSearchDialog.this.dateParse.parse(PatternSearchDialog.this.begin.getText());
                        PatternSearchDialog.this.begin.setText(PatternSearchDialog.this.dateFormat.format(date));
                    }
                    catch (Exception e1) {
                        PatternSearchDialog.this.begin.setText("");
                        CorePlugin.logException((Exception)e1);
                    }
                }
            }
        });
        if (last.get("begin") != null) {
            this.begin.setText((String)last.get("begin"));
        }
        label = new Label(content, 0);
        label.setText("End Date");
        label.setLayoutData((Object)new GridData(125, -1));
        this.end = new Text(content, 2048);
        this.end.setLayoutData((Object)new GridData(80, -1));
        this.end.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (PatternSearchDialog.this.end.getText().length() != 0) {
                    try {
                        Date date = PatternSearchDialog.this.dateParse.parse(PatternSearchDialog.this.end.getText());
                        PatternSearchDialog.this.end.setText(PatternSearchDialog.this.dateFormat.format(date));
                    }
                    catch (Exception e1) {
                        PatternSearchDialog.this.end.setText("");
                        CorePlugin.logException((Exception)e1);
                    }
                }
            }
        });
        if (last.get("end") != null) {
            this.end.setText((String)last.get("end"));
        }
        label = new Label(content, 0);
        label.setText("Period");
        label.setLayoutData((Object)new GridData(125, -1));
        this.period = new Combo(content, 8);
        this.period.add("Daily");
        this.period.add("Weekly");
        this.period.add("Monthly");
        if (last.get("period") != null) {
            this.period.setText((String)last.get("period"));
        } else {
            this.period.select(1);
        }
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(125, -1));
        this.bullishOnly = new Button(content, 32);
        this.bullishOnly.setText("Bullish Only");
        if (last.get("bullishOnly") != null) {
            this.bullishOnly.setSelection(((Boolean)last.get("bullishOnly")).booleanValue());
        }
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(125, -1));
        this.allOccurrences = new Button(content, 32);
        this.allOccurrences.setText("Search all occurrences");
        if (last.get("allOccurrences") != null) {
            this.allOccurrences.setSelection(((Boolean)last.get("allOccurrences")).booleanValue());
        }
        return content;
    }

    public void cancelPressed() {
        super.cancelPressed();
    }

    public void okPressed() {
        last.put("pattern", this.pattern.getText());
        last.put("begin", this.begin.getText());
        last.put("end", this.end.getText());
        last.put("period", this.period.getText());
        last.put("bullishOnly", new Boolean(this.bullishOnly.getSelection()));
        last.put("allOccurrences", new Boolean(this.allOccurrences.getSelection()));
        super.okPressed();
    }
}

