/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.dialogs;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.ClientDlgInfo;
import pk.com.softech.messages.ClientDlgRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.SearchUtil;
import pk.com.softech.tradingterminal.trading.dialogs.BondClientComparator;
import pk.com.softech.tradingterminal.trading.dialogs.BondClientFilter;

public class ClientSearchDialog
extends Dialog
implements ICollectionObserver {
    public static final String ID = "pk.com.softech.tradingterminal.bond.dialogs.BondSecuritySearchDialog";
    public static final String PREFS_BOND_CLIENT_VIEW_COLUMNS = "PREFS_BOND_CLIENT_VIEW_COLUMNS";
    public static final String PREFS_BOND_CLIENT_COLUMNS_SIZE = "PREFS_BOND_CLIENT_COLUMNS_SIZE";
    public static final String PREFS_SORT_COLUMN = "BOND_CLIENT_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "BOND_CLIENT_SORT_DIRECTION";
    private static Logger logger = Logger.getLogger(ClientSearchDialog.class);
    private static String[] COLUMN_NAMES = new String[]{"Client Code", "Client Name"};
    public static final int CLIENT_CODE = 0;
    public static final int CLIENT_NAME = 1;
    private Composite parent;
    private Button searchBtn;
    private Text txtClientCode;
    private Text txtClientName;
    private TableViewer viewer;
    private Table tableViewer;
    private BondClientFilter filter;
    int sortColumn = 0;
    int sortDirection = 1;
    private BondClientComparator comparator;
    private Color colorYellow;
    public ClientDlgInfo curObj;
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientSearchDialog.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientSearchDialog.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(ClientSearchDialog.PREFS_BOND_CLIENT_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = ClientSearchDialog.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (ClientSearchDialog.this.sortColumn == index) {
                ClientSearchDialog.this.sortDirection = ClientSearchDialog.this.sortDirection == 0 ? 1 : 0;
            } else {
                ClientSearchDialog.this.sortColumn = index;
                ClientSearchDialog.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(ClientSearchDialog.PREFS_SORT_COLUMN, ClientSearchDialog.this.sortColumn);
            prefs.setValue(ClientSearchDialog.PREFS_SORT_DIRECTION, ClientSearchDialog.this.sortDirection);
            ClientSearchDialog.this.viewer.getTable().setSortColumn(ClientSearchDialog.this.viewer.getTable().getColumn(ClientSearchDialog.this.sortColumn));
            ClientSearchDialog.this.viewer.getTable().setSortDirection(ClientSearchDialog.this.sortDirection == 0 ? 128 : 1024);
            ClientSearchDialog.this.comparator.setColumn(ClientSearchDialog.this.sortColumn);
            ClientSearchDialog.this.viewer.refresh();
        }
    };

    public ClientSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Security Search");
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CorePlugin.getRepository().allClientList().addCollectionObserver((ICollectionObserver)ClientSearchDialog.this);
                int size = CorePlugin.getRepository().allClientList().size();
                if (size <= 0) {
                    ClientSearchDialog.this.sendClientListingRequest();
                }
            }
        });
        GridData elemGridDataTwoSpan = new GridData();
        elemGridDataTwoSpan.horizontalAlignment = 3;
        elemGridDataTwoSpan.horizontalSpan = 4;
        elemGridDataTwoSpan.widthHint = 70;
        elemGridDataTwoSpan.heightHint = 20;
        Composite compositeHead = new Composite(container, 0);
        compositeHead.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        compositeHead.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(4, 128, true, false);
        gridData.widthHint = 350;
        Composite compositeBody = new Composite(container, 0);
        compositeBody.setLayoutData((Object)gridData);
        compositeBody.setLayout((Layout)new GridLayout(1, false));
        Label lblSecurityCode = new Label(compositeHead, 0x1000000);
        lblSecurityCode.setText("Security Code");
        this.txtClientCode = new Text(compositeHead, 0);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchDialog.this.filter.setSearchText((String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientCode.getText(), (Object)""), (String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientName.getText(), (Object)""));
                ClientSearchDialog.this.viewer.refresh();
            }
        });
        Label lblIssuerName = new Label(compositeHead, 0x1000000);
        lblIssuerName.setText("Issuer Name");
        this.txtClientName = new Text(compositeHead, 0);
        this.txtClientName.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchDialog.this.filter.setSearchText((String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientCode.getText(), (Object)""), (String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientName.getText(), (Object)""));
                ClientSearchDialog.this.viewer.refresh();
            }
        });
        this.searchBtn = new Button(compositeHead, 8);
        this.searchBtn.setText("Search");
        this.searchBtn.setToolTipText("Search");
        this.searchBtn.setLayoutData((Object)elemGridDataTwoSpan);
        this.searchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientSearchDialog.this.filter.setSearchText(ClientSearchDialog.this.txtClientCode.getText(), ClientSearchDialog.this.txtClientName.getText());
            }
        });
        Display display = this.getShell().getDisplay();
        this.colorYellow = new Color((Device)display, 170, 170, 170);
        this.createViewer(compositeBody);
        this.comparator = new BondClientComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.filter = new BondClientFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CorePlugin.getRepository().allClientList().addCollectionObserver((ICollectionObserver)ClientSearchDialog.this);
                ClientSearchDialog.this.viewer.refresh();
            }
        });
        if (Resources.userType != -1 && (Resources.userType == 3 || Resources.userType == 6 || Resources.userType == 8)) {
            this.viewer.setInput((Object)CorePlugin.getRepository().allClientList());
        }
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object o = selection.getFirstElement();
                ClientSearchDialog.this.rowSelected((ClientDlgInfo)o);
            }
        });
        return parent;
    }

    private void rowSelected(ClientDlgInfo obj) {
        this.curObj = obj;
        this.colorYellow.dispose();
        this.tableViewer.dispose();
        CorePlugin.getRepository().allClientList().removeCollectionObserver((ICollectionObserver)this);
        this.close();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.createColumns(parent, this.viewer);
        this.tableViewer = this.viewer.getTable();
        this.tableViewer.setHeaderVisible(true);
        this.tableViewer.setLinesVisible(true);
        this.tableViewer.getHorizontalBar().setEnabled(true);
        this.tableViewer.getVerticalBar().setEnabled(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 350;
        this.tableViewer.setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn(0);
        col.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientCode();
            }

            public void update(ViewerCell cell) {
                String search = (String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientCode.getText(), (Object)"");
                ClientDlgInfo bond = (ClientDlgInfo)cell.getElement();
                String cellText = (String)Utility.getValueOrDefault((Object)bond.getClientCode(), (Object)"");
                cell.setText(cellText);
                if (search != null && search.length() > 0) {
                    int[] intRangesCorrectSize = SearchUtil.getSearchTermOccurrences((String)search, (String)cellText);
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    int i = 0;
                    while (i < intRangesCorrectSize.length / 2) {
                        int start = intRangesCorrectSize[i];
                        int length = intRangesCorrectSize[++i];
                        StyleRange myStyledRange = new StyleRange(start, length, null, ClientSearchDialog.this.colorYellow);
                        styleRange.add(myStyledRange);
                        ++i;
                    }
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                } else {
                    cell.setStyleRanges(null);
                }
                super.update(cell);
            }
        });
        TableViewerColumn col2 = this.createTableViewerColumn(1);
        col2.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientName();
            }

            public void update(ViewerCell cell) {
                String search = (String)Utility.getValueOrDefault((Object)ClientSearchDialog.this.txtClientName.getText(), (Object)"");
                ClientDlgInfo bond = (ClientDlgInfo)cell.getElement();
                String cellText = (String)Utility.getValueOrDefault((Object)bond.getClientName(), (Object)"");
                cell.setText(cellText);
                if (search != null && search.length() > 0) {
                    int[] intRangesCorrectSize = SearchUtil.getSearchTermOccurrences((String)search, (String)cellText);
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    int i = 0;
                    while (i < intRangesCorrectSize.length / 2) {
                        int start = intRangesCorrectSize[i];
                        int length = intRangesCorrectSize[++i];
                        StyleRange myStyledRange = new StyleRange(start, length, null, ClientSearchDialog.this.colorYellow);
                        styleRange.add(myStyledRange);
                        ++i;
                    }
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                } else {
                    cell.setStyleRanges(null);
                }
                super.update(cell);
            }
        });
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_BOND_CLIENT_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 131072);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(String.valueOf(((ClientDlgInfo)cell.getElement()).getClientCode()));
                        break;
                    }
                    case 1: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientName());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientCode();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public boolean close() {
        if (this.colorYellow != null) {
            this.colorYellow.dispose();
        }
        CorePlugin.getRepository().allClientList().removeCollectionObserver((ICollectionObserver)this);
        return super.close();
    }

    public void itemAdded(final Object o) {
        if (this.tableViewer != null && !this.tableViewer.isDisposed()) {
            this.tableViewer.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ClientDlgInfo) {
                        ClientDlgInfo clientObj = (ClientDlgInfo)o;
                        if (ClientSearchDialog.this.tableViewer != null && !ClientSearchDialog.this.tableViewer.isDisposed()) {
                            ClientSearchDialog.this.viewer.add((Object)clientObj);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private void sendClientListingRequest() {
        if (!Resources.isClientType()) {
            try {
                ClientDlgRequest request = new ClientDlgRequest();
                if (!Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request)) {
                    MessageDialog.openError(null, (String)"Connection Error", (String)"You seem to be disconnected from the server. \n Please re-connect again from the file menu.");
                }
            }
            catch (Exception exc) {
                logger.error((Object)"", (Throwable)exc);
            }
        } else {
            this.viewer.setInput(new ArrayList());
        }
    }
}

