/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;

public class TargetVolumePreferences
extends AlertPluginPreferencePage {
    private Combo volumeField;
    private Spinner volume;
    private Label currentVolume;
    private NumberFormat formatter = CorePlugin.getNumberFormatter();
    private Button cross;
    private Label description;
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TargetVolumePreferences.this.updateDescription();
        }
    };

    @Override
    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(content, 0);
        label.setText("Field");
        label.setLayoutData((Object)new GridData(125, -1));
        this.volumeField = new Combo(content, 8);
        this.volumeField.add("Last");
        this.volumeField.add("Bid");
        this.volumeField.add("Ask");
        this.volumeField.add("Turnover");
        this.volumeField.setVisibleItemCount(15);
        this.volumeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetVolumePreferences.this.updateCurrentVolume();
                TargetVolumePreferences.this.updateDescription();
            }
        });
        label = new Label(content, 0);
        label.setText("Volume");
        label.setLayoutData((Object)new GridData(125, -1));
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        this.volume = new Spinner(group, 2048);
        this.volume.setMinimum(0);
        this.volume.setMaximum(999999999);
        this.volume.setDigits(0);
        this.volume.setIncrement(1);
        this.volume.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.currentVolume = new Label(group, 0);
        label = new Label(content, 0);
        this.cross = new Button(content, 32);
        this.cross.setText("Cross");
        this.cross.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000008, true, true, 2, 1));
        int field = 0;
        String value = (String)this.getParameters().get("field");
        if (value != null) {
            field = Integer.parseInt(value);
        }
        this.volumeField.select(field);
        value = (String)this.getParameters().get("volume");
        if (value != null) {
            this.volume.setSelection(Math.round(Long.parseLong(value)));
        } else if (this.getSecurity().getQuote() != null) {
            if (this.volumeField.getSelectionIndex() == 0) {
                this.volume.setSelection((int)this.getSecurity().getQuote().getVolume());
            } else if (this.volumeField.getSelectionIndex() == 1) {
                this.volume.setSelection(this.getSecurity().getQuote().getBidSize());
            } else if (this.volumeField.getSelectionIndex() == 2) {
                this.volume.setSelection(this.getSecurity().getQuote().getAskSize());
            } else if (this.volumeField.getSelectionIndex() == 3) {
                this.volume.setSelection((int)this.getSecurity().getTotalTurnover());
            }
        }
        value = (String)this.getParameters().get("cross");
        if (value != null) {
            this.cross.setSelection(new Boolean(value).booleanValue());
        }
        this.updateCurrentVolume();
        this.updateDescription();
        return content;
    }

    @Override
    public void performOk() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", String.valueOf(this.volumeField.getSelectionIndex()));
        parameters.put("volume", String.valueOf(this.volume.getSelection()));
        parameters.put("cross", String.valueOf(this.cross.getSelection()));
        this.setParameters(parameters);
    }

    private void updateCurrentVolume() {
        if (this.getSecurity().getQuote() != null) {
            if (this.volumeField.getSelectionIndex() == 0) {
                this.currentVolume.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getVolume()) + ")");
            } else if (this.volumeField.getSelectionIndex() == 1) {
                this.currentVolume.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getBidSize()) + ")");
            } else if (this.volumeField.getSelectionIndex() == 2) {
                this.currentVolume.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getAskSize()) + ")");
            } else if (this.volumeField.getSelectionIndex() == 3) {
                this.currentVolume.setText("(current: " + this.formatter.format(this.getSecurity().getTotalTurnover()) + ")");
            }
        } else {
            this.currentVolume.setText("");
        }
        this.currentVolume.getParent().layout();
    }

    private void updateDescription() {
        String s = "Last";
        if (this.volumeField.getSelectionIndex() == 1) {
            s = "Bid";
        } else if (this.volumeField.getSelectionIndex() == 2) {
            s = "Ask";
        } else if (this.volumeField.getSelectionIndex() == 3) {
            s = "Turnover";
        }
        s = String.valueOf(s) + " volume ";
        s = String.valueOf(s) + (this.cross.getSelection() ? "crosses" : "reaches");
        this.description.setText(String.valueOf(s) + " " + this.formatter.format(this.volume.getSelection()));
        this.description.getParent().layout();
    }
}

