/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPlugin;

public class TargetVolume
extends AlertPlugin {
    public static final int LAST = 0;
    public static final int BID = 1;
    public static final int ASK = 2;
    public static final int TURNOVER = 3;
    private int field = 0;
    private long volume = 0L;
    private boolean cross = false;
    private long initialValue = 0L;
    private NumberFormat volumeFormatter = CorePlugin.getNumberFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("field");
        if (value != null) {
            this.field = Integer.parseInt(value);
        }
        if ((value = (String)params.get("volume")) != null) {
            this.volume = Long.parseLong(value);
        }
        if ((value = (String)params.get("cross")) != null) {
            this.cross = new Boolean(value);
        }
        if (this.getSecurity().getQuote() != null) {
            switch (this.field) {
                case 0: {
                    this.initialValue = this.getSecurity().getQuote().getVolume();
                    break;
                }
                case 1: {
                    this.initialValue = this.getSecurity().getQuote().getBidSize();
                    break;
                }
                case 2: {
                    this.initialValue = this.getSecurity().getQuote().getAskSize();
                    break;
                }
                case 3: {
                    this.initialValue = this.getSecurity().getTotalTurnover();
                }
            }
        }
    }

    @Override
    public String getDescription() {
        String s = "Last";
        if (this.field == 1) {
            s = "Bid";
        } else if (this.field == 2) {
            s = "Ask";
        } else if (this.field == 3) {
            s = String.valueOf(s) + "Turnover";
        }
        s = String.valueOf(s) + " volume ";
        s = String.valueOf(s) + (this.cross ? "crosses" : "reaches");
        return String.valueOf(s) + " " + this.volumeFormatter.format(this.volume);
    }

    @Override
    public boolean apply() {
        boolean result;
        long value = 0L;
        if (this.getSecurity().getQuote() == null) {
            return false;
        }
        switch (this.field) {
            case 0: {
                value = this.getSecurity().getQuote().getVolume();
                break;
            }
            case 1: {
                value = this.getSecurity().getQuote().getBidSize();
                break;
            }
            case 2: {
                value = this.getSecurity().getQuote().getAskSize();
                break;
            }
            case 3: {
                value = this.getSecurity().getTotalTurnover();
            }
        }
        if (this.initialValue == 0L) {
            this.initialValue = value;
        }
        boolean bl = this.volume >= this.initialValue ? value > this.volume : (result = value < this.volume);
        if (!this.cross) {
            boolean bl2 = result = value == this.volume;
        }
        if (result) {
            if (!this.cross) {
                this.fireEvent("Target volume " + this.volumeFormatter.format(this.volume) + " reached");
            } else {
                this.fireEvent("Target volume " + this.volumeFormatter.format(this.volume) + " crossed");
            }
        }
        return result;
    }
}

