/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;

public class TargetPricePreferences
extends AlertPluginPreferencePage {
    private Combo priceField;
    private Spinner spnrPriceCross;
    private Spinner spnrPriceDecline;
    private Label currentPrice;
    private NumberFormat formatter = CorePlugin.getPriceFormatter();
    private Button cross;
    private Button decline;
    private Label description;
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TargetPricePreferences.this.updateDescription();
        }
    };

    @Override
    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(content, 0);
        label.setText("Field");
        label.setLayoutData((Object)new GridData(125, -1));
        this.priceField = new Combo(content, 8);
        this.priceField.add("Last");
        this.priceField.add("Bid");
        this.priceField.add("Ask");
        this.priceField.setVisibleItemCount(15);
        this.priceField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPricePreferences.this.updateCurrentPrice();
                TargetPricePreferences.this.updateDescription();
            }
        });
        label = new Label(content, 0);
        label.setText("Price");
        label.setLayoutData((Object)new GridData(125, -1));
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        this.spnrPriceCross = new Spinner(group, 2048);
        this.spnrPriceCross.setMinimum(0);
        this.spnrPriceCross.setMaximum(999999999);
        this.spnrPriceCross.setDigits(2);
        this.spnrPriceCross.setIncrement(1);
        this.spnrPriceCross.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        this.cross = new Button(group, 32);
        this.cross.setText("Cross");
        this.cross.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.spnrPriceDecline = new Spinner(group, 2048);
        this.spnrPriceDecline.setMinimum(0);
        this.spnrPriceDecline.setMaximum(999999999);
        this.spnrPriceDecline.setDigits(2);
        this.spnrPriceDecline.setIncrement(1);
        this.spnrPriceDecline.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.decline = new Button(group, 32);
        this.decline.setText("Decline");
        this.decline.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.currentPrice = new Label(group, 0);
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000008, true, true, 2, 1));
        int field = 0;
        String value = (String)this.getParameters().get("field");
        if (value != null) {
            field = Integer.parseInt(value);
        }
        this.priceField.select(field);
        value = (String)this.getParameters().get("priceCross");
        if (value != null) {
            this.spnrPriceCross.setSelection((int)Math.round(Double.parseDouble(value) * Math.pow(10.0, this.spnrPriceCross.getDigits())));
        } else if (this.getSecurity().getQuote() != null) {
            if (this.priceField.getSelectionIndex() == 0) {
                this.spnrPriceCross.setSelection((int)Math.round(this.getSecurity().getQuote().getLast() * Math.pow(10.0, this.spnrPriceCross.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 1) {
                this.spnrPriceCross.setSelection((int)Math.round(this.getSecurity().getQuote().getBid() * Math.pow(10.0, this.spnrPriceCross.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 2) {
                this.spnrPriceCross.setSelection((int)Math.round(this.getSecurity().getQuote().getAsk() * Math.pow(10.0, this.spnrPriceCross.getDigits())));
            }
        }
        value = (String)this.getParameters().get("cross");
        if (value != null) {
            this.cross.setSelection(new Boolean(value).booleanValue());
        }
        if ((value = (String)this.getParameters().get("priceDecline")) != null) {
            this.spnrPriceDecline.setSelection((int)Math.round(Double.parseDouble(value) * Math.pow(10.0, this.spnrPriceDecline.getDigits())));
        } else if (this.getSecurity().getQuote() != null) {
            if (this.priceField.getSelectionIndex() == 0) {
                this.spnrPriceDecline.setSelection((int)Math.round(this.getSecurity().getQuote().getLast() * Math.pow(10.0, this.spnrPriceDecline.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 1) {
                this.spnrPriceDecline.setSelection((int)Math.round(this.getSecurity().getQuote().getBid() * Math.pow(10.0, this.spnrPriceDecline.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 2) {
                this.spnrPriceDecline.setSelection((int)Math.round(this.getSecurity().getQuote().getAsk() * Math.pow(10.0, this.spnrPriceDecline.getDigits())));
            }
        }
        value = (String)this.getParameters().get("decline");
        if (value != null) {
            this.decline.setSelection(new Boolean(value).booleanValue());
        }
        this.updateCurrentPrice();
        this.updateDescription();
        return content;
    }

    @Override
    public void performOk() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", String.valueOf(this.priceField.getSelectionIndex()));
        parameters.put("priceCross", String.valueOf((double)this.spnrPriceCross.getSelection() / Math.pow(10.0, this.spnrPriceCross.getDigits())));
        parameters.put("cross", String.valueOf(this.cross.getSelection()));
        parameters.put("priceDecline", String.valueOf((double)this.spnrPriceDecline.getSelection() / Math.pow(10.0, this.spnrPriceDecline.getDigits())));
        parameters.put("decline", String.valueOf(this.decline.getSelection()));
        this.setParameters(parameters);
    }

    private void updateCurrentPrice() {
        if (this.getSecurity().getQuote() != null) {
            if (this.priceField.getSelectionIndex() == 0) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getLast()) + ")");
            } else if (this.priceField.getSelectionIndex() == 1) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getBid()) + ")");
            } else if (this.priceField.getSelectionIndex() == 2) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getAsk()) + ")");
            }
        } else {
            this.currentPrice.setText("");
        }
        this.currentPrice.getParent().layout();
    }

    private void updateDescription() {
        String s = "Last";
        if (this.priceField.getSelectionIndex() == 1) {
            s = "Bid";
        } else if (this.priceField.getSelectionIndex() == 2) {
            s = "Ask";
        }
        s = String.valueOf(s) + " price ";
        s = String.valueOf(s) + (this.cross.getSelection() && this.decline.getSelection() ? "crosses " + this.formatter.format((double)this.spnrPriceCross.getSelection() / Math.pow(10.0, this.spnrPriceCross.getDigits())) + " or declines " + this.formatter.format((double)this.spnrPriceDecline.getSelection() / Math.pow(10.0, this.spnrPriceDecline.getDigits())) : (this.cross.getSelection() ? "crosses" : (this.decline.getSelection() ? "declines" : "reaches")));
        if (this.cross.getSelection() && this.decline.getSelection()) {
            this.description.setText(s);
        } else if (this.cross.getSelection()) {
            this.description.setText(String.valueOf(s) + " " + this.formatter.format((double)this.spnrPriceCross.getSelection() / Math.pow(10.0, this.spnrPriceCross.getDigits())));
        } else if (this.decline.getSelection()) {
            this.description.setText(String.valueOf(s) + " " + this.formatter.format((double)this.spnrPriceDecline.getSelection() / Math.pow(10.0, this.spnrPriceDecline.getDigits())));
        } else {
            this.description.setText(String.valueOf(s) + " " + this.formatter.format((double)this.spnrPriceCross.getSelection() / Math.pow(10.0, this.spnrPriceCross.getDigits())));
        }
        this.description.getParent().layout();
    }
}

