/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPlugin;

public class TargetPrice
extends AlertPlugin {
    public static final int LAST = 0;
    public static final int BID = 1;
    public static final int ASK = 2;
    private int field = 0;
    private double priceCross = 0.0;
    private boolean cross = false;
    private double priceDecline = 0.0;
    private boolean decline = false;
    private double initialValue = 0.0;
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("field");
        if (value != null) {
            this.field = Integer.parseInt(value);
        }
        if ((value = (String)params.get("priceCross")) != null) {
            this.priceCross = Double.parseDouble(value);
        }
        if ((value = (String)params.get("cross")) != null) {
            this.cross = new Boolean(value);
        }
        if ((value = (String)params.get("priceDecline")) != null) {
            this.priceDecline = Double.parseDouble(value);
        }
        if ((value = (String)params.get("decline")) != null) {
            this.decline = new Boolean(value);
        }
        if (this.getSecurity().getQuote() != null) {
            switch (this.field) {
                case 0: {
                    this.initialValue = this.getSecurity().getQuote().getLast();
                    break;
                }
                case 1: {
                    this.initialValue = this.getSecurity().getQuote().getBid();
                    break;
                }
                case 2: {
                    this.initialValue = this.getSecurity().getQuote().getAsk();
                }
            }
        }
    }

    @Override
    public String getDescription() {
        String s = "Last";
        if (this.field == 1) {
            s = "Bid";
        } else if (this.field == 2) {
            s = "Ask";
        }
        s = String.valueOf(s) + " price ";
        s = String.valueOf(s) + (this.cross && this.decline ? "crossess " + this.priceFormatter.format(this.priceCross) + " or declines " + this.priceFormatter.format(this.priceDecline) : (this.cross ? "crosses" : (this.decline ? "declines" : "reaches")));
        if (this.decline && this.cross) {
            return s;
        }
        if (this.cross) {
            return String.valueOf(s) + " " + this.priceFormatter.format(this.priceCross);
        }
        if (this.decline) {
            return String.valueOf(s) + " " + this.priceFormatter.format(this.priceDecline);
        }
        return String.valueOf(s) + " " + this.priceFormatter.format(this.priceCross);
    }

    @Override
    public boolean apply() {
        boolean result;
        double value = 0.0;
        if (this.getSecurity().getQuote() == null) {
            return false;
        }
        switch (this.field) {
            case 0: {
                value = this.getSecurity().getQuote().getLast();
                break;
            }
            case 1: {
                value = this.getSecurity().getQuote().getBid();
                break;
            }
            case 2: {
                value = this.getSecurity().getQuote().getAsk();
            }
        }
        if (this.initialValue == 0.0) {
            this.initialValue = value;
        }
        boolean bl = this.priceCross >= this.initialValue || this.priceDecline < this.initialValue ? value > this.priceCross || value < this.priceDecline : (result = value < this.priceCross || value > this.priceDecline);
        if (!this.cross) {
            result = value == this.priceCross;
        } else if (!this.decline) {
            boolean bl2 = result = value == this.priceDecline;
        }
        if (result) {
            if (!this.cross && !this.decline) {
                System.out.println("Price reached");
                this.fireEvent("Target price " + this.priceFormatter.format(this.priceCross) + " reached");
            } else if (!this.cross) {
                System.out.println("Price crossed");
                this.fireEvent("Target price " + this.priceFormatter.format(this.priceCross) + " crossed");
            } else if (!this.decline) {
                System.out.println("price declined");
                this.fireEvent("Target price " + this.priceFormatter.format(this.priceDecline) + " declined");
            }
        }
        return result;
    }
}

