/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.util.HashMap;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;

public class RSICrossoverPreferences
extends AlertPluginPreferencePage {
    private Combo interval;
    private Spinner period;
    private Spinner level;
    private Combo direction;
    private Label description;
    private ColorSelector color;
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            RSICrossoverPreferences.this.updateDescription();
        }
    };

    @Override
    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(content, 0);
        label.setText("Interval");
        label.setLayoutData((Object)new GridData(125, -1));
        this.interval = new Combo(content, 8);
        this.interval.add("Daily");
        this.interval.add("Weekly");
        this.interval.add("Monthly");
        this.interval.setVisibleItemCount(15);
        this.interval.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        label.setText("Period");
        label.setLayoutData((Object)new GridData(125, -1));
        this.period = new Spinner(content, 2048);
        this.period.setMinimum(0);
        this.period.setMaximum(99999);
        this.period.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        label.setText("Direction");
        label.setLayoutData((Object)new GridData(125, -1));
        this.direction = new Combo(content, 8);
        this.direction.add("Upward");
        this.direction.add("Downward");
        this.direction.setVisibleItemCount(15);
        this.direction.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        label.setText("Level");
        this.level = new Spinner(content, 2048);
        this.level.setMinimum(0);
        this.level.setMaximum(99999);
        this.level.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        label.setText("Hilight Color");
        label.setLayoutData((Object)new GridData(125, -1));
        this.color = new ColorSelector(content);
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000008, true, true, 2, 1));
        int field = 8;
        String value = (String)this.getParameters().get("interval");
        if (value != null) {
            field = Integer.parseInt(value);
        }
        this.interval.select(field - 8);
        value = (String)this.getParameters().get("level");
        this.level.setSelection(value != null ? Integer.parseInt(value) : 80);
        value = (String)this.getParameters().get("period");
        this.period.setSelection(value != null ? Integer.parseInt(value) : 7);
        field = 0;
        value = (String)this.getParameters().get("direction");
        if (value != null) {
            field = Integer.parseInt(value);
        }
        this.direction.select(field);
        value = (String)this.getParameters().get("hilightBackground");
        if (value != null) {
            String[] ar = value.split(",");
            this.color.setColorValue(new RGB(Integer.parseInt(ar[0]), Integer.parseInt(ar[1]), Integer.parseInt(ar[2])));
        } else {
            this.color.setColorValue(new RGB(0, 224, 0));
        }
        this.updateDescription();
        return content;
    }

    @Override
    public void performOk() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("interval", String.valueOf(this.interval.getSelectionIndex() + 8));
        parameters.put("period", String.valueOf(this.period.getSelection()));
        parameters.put("level", String.valueOf(this.level.getSelection()));
        parameters.put("direction", String.valueOf(this.direction.getSelectionIndex()));
        RGB rgb = this.color.getColorValue();
        parameters.put("hilightBackground", String.valueOf(String.valueOf(rgb.red)) + "," + String.valueOf(rgb.green) + "," + String.valueOf(rgb.blue));
        this.setParameters(parameters);
    }

    private void updateDescription() {
        String s = "When the " + String.valueOf(this.period.getSelection());
        switch (this.interval.getSelectionIndex() + 8) {
            case 8: {
                s = String.valueOf(s) + " days";
                break;
            }
            case 9: {
                s = String.valueOf(s) + " weeks";
                break;
            }
            case 10: {
                s = String.valueOf(s) + " months";
            }
        }
        s = String.valueOf(s) + " RSI goes";
        if (this.direction.getSelectionIndex() == 0) {
            s = String.valueOf(s) + " upward";
        } else if (this.direction.getSelectionIndex() == 1) {
            s = String.valueOf(s) + " downward";
        }
        s = String.valueOf(s) + " " + String.valueOf(this.level.getSelection());
        this.description.setText(s);
        this.description.getParent().layout();
    }
}

