/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.BarData;
import pk.com.softech.tradingterminal.trading.AlertPlugin;

public class RSICrossover
extends AlertPlugin {
    public static final int OPEN = 0;
    public static final int HIGH = 1;
    public static final int LOW = 2;
    public static final int CLOSE = 3;
    public static final int DAILY = 8;
    public static final int WEEKLY = 9;
    public static final int MONTHLY = 10;
    public static final int UPWARD = 0;
    public static final int DOWNWARD = 1;
    private int field = 3;
    private int period = 7;
    private int interval = 9;
    private int direction = 0;
    private int level = 80;
    private RGB hilightColor = new RGB(255, 0, 0);
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("field");
        if (value != null) {
            this.field = Integer.parseInt(value);
        }
        if ((value = (String)params.get("level")) != null) {
            this.level = Integer.parseInt(value);
        }
        if ((value = (String)params.get("period")) != null) {
            this.period = Integer.parseInt(value);
        }
        if ((value = (String)params.get("interval")) != null) {
            this.interval = Integer.parseInt(value);
        }
        if ((value = (String)params.get("direction")) != null) {
            this.direction = Integer.parseInt(value);
        }
        if ((value = (String)params.get("hilightBackground")) != null) {
            String[] ar = value.split(",");
            this.hilightColor = new RGB(Integer.parseInt(ar[0]), Integer.parseInt(ar[1]), Integer.parseInt(ar[2]));
        }
    }

    @Override
    public String getDescription() {
        String s = "When the " + String.valueOf(this.period);
        switch (this.interval) {
            case 8: {
                s = String.valueOf(s) + " days";
                break;
            }
            case 9: {
                s = String.valueOf(s) + " weeks";
                break;
            }
            case 10: {
                s = String.valueOf(s) + " months";
            }
        }
        s = String.valueOf(s) + " RSI goes";
        if (this.direction == 0) {
            s = String.valueOf(s) + " over";
        } else if (this.direction == 1) {
            s = String.valueOf(s) + " under";
        }
        s = String.valueOf(s) + " " + String.valueOf(this.level);
        return s;
    }

    @Override
    public boolean apply() {
        BarData barData = new BarData(this.getSecurity().getHistory().getList());
        switch (this.interval) {
            case 8: {
                break;
            }
            case 9: {
                barData = barData.getCompressed(9);
                break;
            }
            case 10: {
                barData = barData.getCompressed(10);
            }
        }
        if (barData.size() <= this.period || barData.size() == 0 || this.getSecurity().getQuote() == null) {
            return false;
        }
        double value = this.getRSI(barData, this.field, this.period, this.getSecurity().getQuote().getLast());
        boolean result = false;
        if (this.direction == 0) {
            result = value > (double)this.level;
        } else if (this.direction == 1) {
            boolean bl = result = value < (double)this.level;
        }
        if (result) {
            String s = "The " + String.valueOf(this.period);
            switch (this.interval) {
                case 8: {
                    s = String.valueOf(s) + " days";
                    break;
                }
                case 9: {
                    s = String.valueOf(s) + " weeks";
                    break;
                }
                case 10: {
                    s = String.valueOf(s) + " months";
                }
            }
            s = String.valueOf(s) + " RSI has gone";
            if (this.direction == 0) {
                s = String.valueOf(s) + " over";
            } else if (this.direction == 1) {
                s = String.valueOf(s) + " under";
            }
            s = String.valueOf(s) + " " + String.valueOf(this.level) + "%";
            s = String.valueOf(s) + " at " + this.priceFormatter.format(value) + "% with price at " + this.priceFormatter.format(this.getSecurity().getQuote().getLast());
            this.fireEvent(s);
        }
        return result;
    }

    @Override
    public RGB getHilightBackground() {
        return this.hilightColor;
    }

    private double getRSI(BarData in, int field, int period, double lastPrice) {
        double rsi = 0.0;
        if (period < 1 || period >= in.size()) {
            return rsi;
        }
        double[] data = new double[period + 1];
        int index = in.size() - period;
        int i = 0;
        while (i < data.length - 1) {
            switch (field) {
                case 0: {
                    data[i] = in.getOpen(index);
                    break;
                }
                case 1: {
                    data[i] = in.getHigh(index);
                    break;
                }
                case 2: {
                    data[i] = in.getLow(index);
                    break;
                }
                case 3: {
                    data[i] = in.getClose(index);
                }
            }
            ++i;
            ++index;
        }
        data[data.length - 1] = lastPrice;
        int loop = period;
        while (loop < data.length) {
            double loss = 0.0;
            double gain = 0.0;
            int loop2 = 0;
            while (loop2 < period) {
                double t = data[loop - loop2] - data[loop - loop2 - 1];
                if (t > 0.0) {
                    gain += t;
                }
                if (t < 0.0) {
                    loss += Math.abs(t);
                }
                ++loop2;
            }
            double again = gain / (double)period;
            double aloss = loss / (double)period;
            double rs = again / aloss;
            double t = 100.0 - 100.0 / (1.0 + rs);
            if (t > 100.0) {
                t = 100.0;
            }
            if (t < 0.0) {
                t = 0.0;
            }
            rsi = t;
            ++loop;
        }
        return rsi;
    }
}

