/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;

public class PriceChangePreferences
extends AlertPluginPreferencePage {
    private Combo priceField;
    private Spinner change;
    private Spinner reference;
    private Label currentPrice;
    private Label description;
    private NumberFormat formatter = CorePlugin.getPriceFormatter();
    private NumberFormat percentFormatter = CorePlugin.getPercentageFormatter();
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PriceChangePreferences.this.updateDescription();
        }
    };

    @Override
    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(content, 0);
        label.setText("Field");
        label.setLayoutData((Object)new GridData(125, -1));
        this.priceField = new Combo(content, 8);
        this.priceField.add("Last");
        this.priceField.add("Bid");
        this.priceField.add("Ask");
        this.priceField.setVisibleItemCount(15);
        this.priceField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PriceChangePreferences.this.updateCurrentPrice();
                PriceChangePreferences.this.updateDescription();
            }
        });
        label = new Label(content, 0);
        label.setText("Change (%)");
        label.setLayoutData((Object)new GridData(125, -1));
        this.change = new Spinner(content, 2048);
        this.change.setMinimum(0);
        this.change.setMaximum(99999);
        this.change.setDigits(2);
        this.change.addSelectionListener((SelectionListener)this.selectionAdapter);
        label = new Label(content, 0);
        label.setText("Reference Price");
        label.setLayoutData((Object)new GridData(125, -1));
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        this.reference = new Spinner(group, 2048);
        this.reference.setMinimum(0);
        this.reference.setMaximum(99999999);
        this.reference.setDigits(2);
        this.reference.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.currentPrice = new Label(group, 0);
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000008, true, true, 2, 1));
        int field = 0;
        String value = (String)this.getParameters().get("field");
        if (value != null) {
            field = Integer.parseInt(value);
        }
        this.priceField.select(field);
        value = (String)this.getParameters().get("change");
        if (value != null) {
            this.change.setSelection((int)Math.round(Double.parseDouble(value) * Math.pow(10.0, this.change.getDigits())));
        } else {
            this.change.setSelection((int)Math.round(1.0 * Math.pow(10.0, this.change.getDigits())));
        }
        value = (String)this.getParameters().get("reference");
        if (value != null) {
            this.reference.setSelection((int)Math.round(Double.parseDouble(value) * Math.pow(10.0, this.reference.getDigits())));
        } else if (this.getSecurity().getQuote() != null) {
            if (this.priceField.getSelectionIndex() == 0) {
                this.reference.setSelection((int)Math.round(this.getSecurity().getQuote().getLast() * Math.pow(10.0, this.reference.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 1) {
                this.reference.setSelection((int)Math.round(this.getSecurity().getQuote().getBid() * Math.pow(10.0, this.reference.getDigits())));
            } else if (this.priceField.getSelectionIndex() == 2) {
                this.reference.setSelection((int)Math.round(this.getSecurity().getQuote().getAsk() * Math.pow(10.0, this.reference.getDigits())));
            }
        }
        this.updateCurrentPrice();
        this.updateDescription();
        return content;
    }

    @Override
    public void performOk() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", String.valueOf(this.priceField.getSelectionIndex()));
        parameters.put("change", String.valueOf((double)this.change.getSelection() / Math.pow(10.0, this.change.getDigits())));
        parameters.put("reference", String.valueOf((double)this.reference.getSelection() / Math.pow(10.0, this.reference.getDigits())));
        this.setParameters(parameters);
    }

    private void updateCurrentPrice() {
        if (this.getSecurity().getQuote() != null) {
            if (this.priceField.getSelectionIndex() == 0) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getLast()) + ")");
            } else if (this.priceField.getSelectionIndex() == 1) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getBid()) + ")");
            } else if (this.priceField.getSelectionIndex() == 2) {
                this.currentPrice.setText("(current: " + this.formatter.format(this.getSecurity().getQuote().getAsk()) + ")");
            }
        } else {
            this.currentPrice.setText("");
        }
        this.currentPrice.getParent().layout();
    }

    private void updateDescription() {
        String s = "Last";
        if (this.priceField.getSelectionIndex() == 1) {
            s = "Bid";
        } else if (this.priceField.getSelectionIndex() == 2) {
            s = "Ask";
        }
        s = String.valueOf(s) + " price changes by " + this.percentFormatter.format((double)this.change.getSelection() / Math.pow(10.0, this.change.getDigits())) + "%";
        s = String.valueOf(s) + " from " + this.formatter.format((double)this.reference.getSelection() / Math.pow(10.0, this.reference.getDigits()));
        this.description.setText(s);
        this.description.getParent().layout();
    }
}

