/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.AlertPlugin;

public class PriceChange
extends AlertPlugin {
    public static final int LAST = 0;
    public static final int BID = 1;
    public static final int ASK = 2;
    private int field = 0;
    private double change = 0.0;
    private double reference = 0.0;
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();
    private NumberFormat percentFormatter = CorePlugin.getPercentageFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("field");
        if (value != null) {
            this.field = Integer.parseInt(value);
        }
        if ((value = (String)params.get("reference")) != null) {
            this.reference = Double.parseDouble(value);
        }
        if ((value = (String)params.get("change")) != null) {
            this.change = Double.parseDouble(value);
        }
        if (this.getSecurity().getQuote() != null) {
            switch (this.field) {
                case 0: {
                    this.reference = this.getSecurity().getQuote().getLast();
                    break;
                }
                case 1: {
                    this.reference = this.getSecurity().getQuote().getBid();
                    break;
                }
                case 2: {
                    this.reference = this.getSecurity().getQuote().getAsk();
                }
            }
        }
    }

    @Override
    public String getDescription() {
        String s = "Last";
        if (this.field == 1) {
            s = "Bid";
        } else if (this.field == 2) {
            s = "Ask";
        }
        return String.valueOf(s) + " price changes by " + this.percentFormatter.format(this.change) + "% from " + this.priceFormatter.format(this.reference);
    }

    @Override
    public boolean apply() {
        double percent;
        boolean result;
        double value = 0.0;
        if (this.getSecurity().getQuote() == null) {
            return false;
        }
        switch (this.field) {
            case 0: {
                value = this.getSecurity().getQuote().getLast();
                break;
            }
            case 1: {
                value = this.getSecurity().getQuote().getBid();
                break;
            }
            case 2: {
                value = this.getSecurity().getQuote().getAsk();
            }
        }
        if (this.reference == 0.0) {
            this.reference = value;
        }
        boolean bl = result = (percent = Math.abs(value - this.reference) / this.reference * 100.0) >= this.change;
        if (result) {
            this.fireEvent("Price change of " + this.percentFormatter.format(this.change) + "% at " + this.priceFormatter.format(value));
        }
        return result;
    }
}

