/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.BarData;
import pk.com.softech.tradingterminal.trading.AlertPlugin;

public class PriceAlert
extends AlertPlugin {
    public static final int DAILY = 8;
    public static final int WEEKLY = 9;
    public static final int MONTHLY = 10;
    public static final int HIGH = 0;
    public static final int LOW = 1;
    private int period = 2;
    private int interval = 9;
    private int type = 0;
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("period");
        if (value != null) {
            this.period = Integer.parseInt(value);
        }
        if ((value = (String)params.get("interval")) != null) {
            this.interval = Integer.parseInt(value);
        }
        if ((value = (String)params.get("type")) != null) {
            this.type = Integer.parseInt(value);
        }
    }

    @Override
    public String getDescription() {
        String s = "Price reaches a new " + String.valueOf(this.period);
        switch (this.interval) {
            case 8: {
                s = String.valueOf(s) + " days";
                break;
            }
            case 9: {
                s = String.valueOf(s) + " weeks";
                break;
            }
            case 10: {
                s = String.valueOf(s) + " months";
            }
        }
        s = String.valueOf(s) + (this.type == 0 ? " high" : " low");
        return s;
    }

    @Override
    public boolean apply() {
        BarData barData = new BarData(this.getSecurity().getHistory().getList());
        switch (this.interval) {
            case 8: {
                break;
            }
            case 9: {
                barData = barData.getCompressed(9);
                break;
            }
            case 10: {
                barData = barData.getCompressed(10);
            }
        }
        if (barData.size() < this.period || barData.size() == 0) {
            return false;
        }
        boolean result = false;
        double value = 0.0;
        if (this.type == 0) {
            if (this.getSecurity().getHigh() == null) {
                return false;
            }
            double max = 0.0;
            int i = barData.size() - this.period;
            while (i < barData.size()) {
                max = Math.max(max, barData.getHigh(i));
                ++i;
            }
            value = this.getSecurity().getHigh();
            result = value > max;
        } else if (this.type == 1) {
            if (this.getSecurity().getLow() == null) {
                return false;
            }
            double min = 999999.0;
            int i = barData.size() - this.period;
            while (i < barData.size()) {
                min = Math.min(min, barData.getLow(i));
                ++i;
            }
            value = this.getSecurity().getLow();
            boolean bl = result = value < min;
        }
        if (result) {
            String s = "Price reached a new " + String.valueOf(this.period);
            switch (this.interval) {
                case 8: {
                    s = String.valueOf(s) + " days";
                    break;
                }
                case 9: {
                    s = String.valueOf(s) + " weeks";
                    break;
                }
                case 10: {
                    s = String.valueOf(s) + " months";
                }
            }
            s = String.valueOf(s) + (this.type == 0 ? " high" : " low");
            s = String.valueOf(s) + " at " + this.priceFormatter.format(value);
            this.fireEvent(s);
        }
        return result;
    }
}

