/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import java.text.NumberFormat;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.BarData;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.alerts.MA;

public class MovingAverageCrossover
extends AlertPlugin {
    public static final int OPEN = 0;
    public static final int HIGH = 1;
    public static final int LOW = 2;
    public static final int CLOSE = 3;
    public static final int DAILY = 8;
    public static final int WEEKLY = 9;
    public static final int MONTHLY = 10;
    public static final int UPWARD = 0;
    public static final int DOWNWARD = 1;
    private int field = 3;
    private int maType = 1;
    private int period = 7;
    private int interval = 3;
    private int direction = 0;
    private RGB hilightColor = new RGB(255, 0, 0);
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();

    @Override
    public void init(Map params) {
        String value = (String)params.get("field");
        if (value != null) {
            this.field = Integer.parseInt(value);
        }
        if ((value = (String)params.get("maType")) != null) {
            this.maType = Integer.parseInt(value);
        }
        if ((value = (String)params.get("period")) != null) {
            this.period = Integer.parseInt(value);
        }
        if ((value = (String)params.get("interval")) != null) {
            this.interval = Integer.parseInt(value);
        }
        if ((value = (String)params.get("direction")) != null) {
            this.direction = Integer.parseInt(value);
        }
        if ((value = (String)params.get("hilightBackground")) != null) {
            String[] ar = value.split(",");
            this.hilightColor = new RGB(Integer.parseInt(ar[0]), Integer.parseInt(ar[1]), Integer.parseInt(ar[2]));
        }
    }

    @Override
    public String getDescription() {
        String s = "Price crosses";
        if (this.direction == 0) {
            s = String.valueOf(s) + " upward";
        } else if (this.direction == 1) {
            s = String.valueOf(s) + " downward";
        }
        s = String.valueOf(s) + " over its " + String.valueOf(this.period);
        switch (this.interval) {
            case 8: {
                s = String.valueOf(s) + " days";
                break;
            }
            case 9: {
                s = String.valueOf(s) + " weeks";
                break;
            }
            case 10: {
                s = String.valueOf(s) + " months";
            }
        }
        switch (this.maType) {
            case 0: {
                s = String.valueOf(s);
                break;
            }
            case 1: {
                s = String.valueOf(s) + " exponential";
                break;
            }
            case 2: {
                s = String.valueOf(s) + " weighted";
                break;
            }
            case 3: {
                s = String.valueOf(s) + " Wilder's";
            }
        }
        s = String.valueOf(s) + " moving average";
        return s;
    }

    @Override
    public boolean apply() {
        BarData barData = new BarData(this.getSecurity().getHistory().getList());
        switch (this.interval) {
            case 8: {
                break;
            }
            case 9: {
                barData = barData.getCompressed(9);
                break;
            }
            case 10: {
                barData = barData.getCompressed(10);
            }
        }
        if (barData.size() <= this.period || barData.size() == 0 || this.getSecurity().getQuote() == null) {
            return false;
        }
        double value = MA.getMA(barData, this.field, this.maType, this.period);
        boolean result = false;
        if (this.direction == 0) {
            result = this.getSecurity().getQuote().getLast() > value;
        } else if (this.direction == 1) {
            boolean bl = result = this.getSecurity().getQuote().getLast() < value;
        }
        if (result) {
            String s = "Price crossed";
            if (this.direction == 0) {
                s = String.valueOf(s) + " upward";
            } else if (this.direction == 1) {
                s = String.valueOf(s) + " downward";
            }
            s = String.valueOf(s) + " over its " + String.valueOf(this.period);
            switch (this.interval) {
                case 8: {
                    s = String.valueOf(s) + " days";
                    break;
                }
                case 9: {
                    s = String.valueOf(s) + " weeks";
                    break;
                }
                case 10: {
                    s = String.valueOf(s) + " months";
                }
            }
            switch (this.maType) {
                case 0: {
                    s = String.valueOf(s);
                    break;
                }
                case 1: {
                    s = String.valueOf(s) + " exponential";
                    break;
                }
                case 2: {
                    s = String.valueOf(s) + " weighted";
                    break;
                }
                case 3: {
                    s = String.valueOf(s) + " Wilder's";
                }
            }
            s = String.valueOf(s) + " moving average at " + this.priceFormatter.format(this.getSecurity().getQuote().getLast());
            this.fireEvent(s);
        }
        return result;
    }

    @Override
    public RGB getHilightBackground() {
        return this.hilightColor;
    }
}

