/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.alerts;

import pk.com.softech.tradingterminal.core.db.BarData;

public class MA {
    public static final int SMA = 0;
    public static final int EMA = 1;
    public static final int WMA = 2;
    public static final int Wilder = 3;

    public static double getMA(BarData in, int field, int type, int period) {
        double ma = 0.0;
        if (period < 1 || period >= in.size()) {
            return ma;
        }
        double[] data = new double[period + 1];
        int index = in.size() - period - 1;
        int i = 0;
        while (i < data.length) {
            switch (field) {
                case 0: {
                    data[i] = in.getOpen(index);
                    break;
                }
                case 1: {
                    data[i] = in.getHigh(index);
                    break;
                }
                case 2: {
                    data[i] = in.getLow(index);
                    break;
                }
                case 3: {
                    data[i] = in.getClose(index);
                }
            }
            ++i;
            ++index;
        }
        switch (type) {
            case 0: {
                ma = MA.getSMA(data, period);
                break;
            }
            case 1: {
                ma = MA.getEMA(data, period);
                break;
            }
            case 2: {
                ma = MA.getWMA(data, period);
                break;
            }
            case 3: {
                ma = MA.getWilderMA(data, period);
            }
        }
        return ma;
    }

    public static double getEMA(double[] data, int period) {
        double yesterday;
        double result = 0.0;
        if (period < 1 || period >= data.length) {
            return result;
        }
        double smoother = 2.0 / (double)(period + 1);
        double t = 0.0;
        int loop = 0;
        while (loop < period) {
            t += data[loop];
            ++loop;
        }
        result = yesterday = t / (double)period;
        while (loop < data.length) {
            double t1;
            yesterday = t1 = smoother * (data[loop] - yesterday) + yesterday;
            result = t1;
            ++loop;
        }
        return result;
    }

    public static double getSMA(double[] data, int period) {
        double result = 0.0;
        if (period < 1 || period >= data.length) {
            return result;
        }
        double[] values = new double[period];
        double total = 0.0;
        int loop = -1;
        while (++loop < period) {
            double val = data[loop];
            total += val;
            values[loop] = val;
        }
        result = total / (double)period;
        --loop;
        while (++loop < data.length) {
            int index = loop % period;
            double newval = data[loop];
            total += newval;
            values[index] = newval;
            result = (total -= values[index]) / (double)period;
        }
        return result;
    }

    public static double getWMA(double[] data, int period) {
        double result = 0.0;
        if (period < 1 || period >= data.length) {
            return result;
        }
        int loop = period - 1;
        while (loop < data.length) {
            int loop2 = period - 1;
            int weight = 1;
            int divider = 0;
            double total = 0.0;
            while (loop2 >= 0) {
                total += data[loop - loop2] * (double)weight;
                divider += weight;
                --loop2;
                ++weight;
            }
            result = total / (double)divider;
            ++loop;
        }
        return result;
    }

    public static double getWilderMA(double[] data, int period) {
        double yesterday;
        double result = 0.0;
        if (period < 1 || period >= data.length) {
            return result;
        }
        double t = 0.0;
        int loop = 0;
        while (loop < period) {
            t += data[loop];
            ++loop;
        }
        result = yesterday = t / (double)period;
        while (loop < data.length) {
            double t1;
            yesterday = t1 = (yesterday * (double)(period - 1) + data[loop]) / (double)period;
            result = t1;
            ++loop;
        }
        return result;
    }
}

