/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.ui.SecuritySelection;
import pk.com.softech.tradingterminal.trading.views.QuoteRequestView;
import pk.com.softech.tradingterminal.trading.views.SecuritiesView;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;

public class SymbolSummaryAction
extends Action {
    private ViewPart view = null;

    public SymbolSummaryAction(ViewPart view) {
        this.setText("View Symbol Summary");
        this.view = view;
    }

    public void run() {
        if (this.view != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ISelection selection = page.getSelection();
            try {
                ViewPart v;
                Security security = null;
                if (this.view instanceof SecuritiesView) {
                    v = (SecuritiesView)this.view;
                    if (v.getSelection() != null && v.getSelection().length > 0) {
                        security = v.getSelection()[0];
                    }
                } else if (this.view instanceof WatchlistView) {
                    v = (WatchlistView)this.view;
                    WatchlistItem[] watchItem = v.getSelection();
                    if (watchItem != null && watchItem.length > 0) {
                        security = watchItem[0].getSecurity();
                    }
                } else if (selection != null && selection instanceof SecuritySelection) {
                    security = ((SecuritySelection)selection).getSecurity();
                }
                QuoteRequestView view = (QuoteRequestView)page.showView("pk.com.softech.tradingterminal.trading.quoteRequest");
                if (security != null) {
                    view.setSecurity(security);
                }
            }
            catch (PartInitException e) {
                CorePlugin.logException((Exception)((Object)e));
            }
        }
    }
}

