/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IHistoryFeed;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemPlugin;

public class RunTradingSystemAction
implements IViewActionDelegate {
    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        Job job = new Job("Updating Trading System Signals"){

            protected IStatus run(IProgressMonitor monitor) {
                ObservableList list = CorePlugin.getRepository().getTradingSystems();
                monitor.beginTask("Updating Trading System Signals", list.size());
                for (TradingSystem system : list) {
                    if (system.getSecurity().getHistoryFeed() != null) {
                        String id = system.getSecurity().getHistoryFeed().getId();
                        IHistoryFeed feed = CorePlugin.createHistoryFeedPlugin((String)id);
                        monitor.subTask(String.valueOf(system.getSecurity().getDescription()) + " - Updating history");
                        feed.updateHistory(system.getSecurity(), 8);
                    }
                    monitor.subTask(String.valueOf(system.getSecurity().getDescription()) + " - Running trading system");
                    TradingSystemPlugin plugin = TradingPlugin.createTradingSystemPlugin(system);
                    plugin.run();
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

