/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.WatchlistData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.wizards.WatchlistWizard;

public class OpenWatchlistAction
implements IWorkbenchWindowPulldownDelegate2,
SelectionListener,
ICollectionObserver,
Observer {
    private static OpenWatchlistAction instance;
    private Menu menu;
    private Log log = LogFactory.getLog(this.getClass());
    private Menu subMenuCustom;
    private Menu _parent;
    private boolean sysWatchCreated;
    int i = 0;

    public static OpenWatchlistAction getInstance() {
        return instance;
    }

    public void init(IWorkbenchWindow window) {
        instance = this;
    }

    public void dispose() {
        CorePlugin.getRepository().allWatchlists().removeCollectionObserver((ICollectionObserver)this);
        if (this.menu != null && !this.menu.isDisposed()) {
            MenuItem[] items = this.menu.getItems();
            int i = 0;
            while (i < items.length) {
                ((Watchlist)items[i].getData()).deleteObserver((Observer)this);
                ++i;
            }
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        this._parent = parent;
        if (this.menu != null) {
            this.menu.dispose();
            CorePlugin.getRepository().allWatchlists().removeCollectionObserver((ICollectionObserver)this);
        }
        this.menu = new Menu(parent);
        ObservableList list = CorePlugin.getRepository().allWatchlists();
        MenuItem newWatchList = new MenuItem(this.menu, 0);
        newWatchList.setText("New WatchList");
        newWatchList.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD").createImage());
        newWatchList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WatchlistWizard wizard = new WatchlistWizard();
                wizard.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem customItem = new MenuItem(this.menu, 64);
        customItem.setText("Custom Watches");
        customItem.setImage(TradingPlugin.getImageDescriptor("/icons/eview16/book.png").createImage());
        Menu filemenu = new Menu((Decorations)parent.getShell(), 4);
        customItem.setMenu(filemenu);
        this.subMenuCustom = new Menu((Decorations)parent.getShell(), 4);
        customItem.setMenu(this.subMenuCustom);
        if (list.size() != 0) {
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Watchlist)arg0).getDescription().compareTo(((Watchlist)arg1).getDescription());
                }
            });
            for (Watchlist watchlist : list) {
                MenuItem item = new MenuItem(this.subMenuCustom, 0);
                item.setText(watchlist.getDescription());
                item.setData((Object)watchlist);
                try {
                    item.setImage(TradingPlugin.getImageDescriptor("/icons/eview16/book.png").createImage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                item.addSelectionListener((SelectionListener)this);
                watchlist.addObserver((Observer)this);
            }
        }
        try {
            WatchlistData sysWatch = Resources.sysWatch;
            if (sysWatch != null && sysWatch.hasChild()) {
                this.createMenus(this.menu, parent, sysWatch);
                this.sysWatchCreated = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CorePlugin.getRepository().allWatchlists().addCollectionObserver((ICollectionObserver)this);
        return this.menu;
    }

    private void createMenus(Menu menu, Menu parent, WatchlistData sysWatch) {
        try {
            if (this.sysWatchCreated) {
                return;
            }
            MenuItem parentItem = new MenuItem(menu, 64);
            parentItem.setText(sysWatch.getName());
            parentItem.setImage(TradingPlugin.getImageDescriptor("/icons/eview16/computer.png").createImage());
            Menu subMenuCustom = new Menu((Decorations)parent.getShell(), 4);
            parentItem.setMenu(subMenuCustom);
            List list = sysWatch.getSubWatches();
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    WatchlistData w1 = (WatchlistData)arg0;
                    WatchlistData w2 = (WatchlistData)arg1;
                    if (w1.hasChild()) {
                        return 1;
                    }
                    if (w2.hasChild()) {
                        return -1;
                    }
                    return ((WatchlistData)arg0).getName().compareTo(((WatchlistData)arg1).getName());
                }
            });
            int i = 0;
            while (i < list.size()) {
                WatchlistData syswatchData = (WatchlistData)list.get(i);
                if (!syswatchData.hasChild()) {
                    Watchlist watchlist = (Watchlist)CorePlugin.getRepository().load(Watchlist.class, syswatchData.getId());
                    MenuItem childItem = new MenuItem(subMenuCustom, 0);
                    childItem.setImage(TradingPlugin.getImageDescriptor("/icons/eview16/computer.png").createImage());
                    childItem.setText(syswatchData.getName());
                    childItem.addSelectionListener((SelectionListener)this);
                    childItem.setData((Object)watchlist);
                    watchlist.addObserver((Observer)this);
                    if (syswatchData.getName().equalsIgnoreCase("MY WATCH")) {
                        Resources.MyWatch = watchlist;
                    }
                } else {
                    this.createMenus(subMenuCustom, parent, syswatchData);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Exception in creating Watchlist Menu " + e));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Watchlist watchlist = (Watchlist)o;
        try {
            MenuItem[] items = this.menu.getItems();
            int i = 0;
            while (i < items.length) {
                if (watchlist.equals(items[i].getData()) && !items[i].getText().equals(watchlist.getDescription())) {
                    items[i].setText(watchlist.getDescription());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void itemAdded(Object o) {
        Watchlist watchlist = (Watchlist)o;
        MenuItem item = new MenuItem(this.subMenuCustom, 0);
        item.setText(watchlist.getDescription());
        item.setData((Object)watchlist);
        try {
            item.setImage(TradingPlugin.getImageDescriptor("/icons/eview16/book.png").createImage());
        }
        catch (Exception exception) {}
        item.addSelectionListener((SelectionListener)this);
    }

    public void itemRemoved(Object o) {
        Watchlist watchlist = (Watchlist)o;
        MenuItem[] items = this.menu.getItems();
        int j = 0;
        while (j < items.length) {
            if (items[j].getMenu() != null) {
                MenuItem[] itemsub = items[j].getMenu().getItems();
                int i = 0;
                while (i < itemsub.length) {
                    if (watchlist.equals(itemsub[i].getData())) {
                        itemsub[i].dispose();
                        watchlist.deleteObserver((Observer)this);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Watchlist watchlist = (Watchlist)((MenuItem)e.getSource()).getData();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("pk.com.softech.tradingterminal.trading.watchlist", String.valueOf(watchlist.getId()), 1);
        }
        catch (PartInitException e1) {
            CorePlugin.logException((Exception)((Object)e1));
        }
    }

    public void widgetSelected() {
        Watchlist watchlist = Resources.MyWatch;
        if (watchlist != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.showView("pk.com.softech.tradingterminal.trading.watchlist", String.valueOf(watchlist.getId()), 1);
            }
            catch (PartInitException e1) {
                CorePlugin.logException((Exception)((Object)e1));
            }
        }
    }

    public void createSystemWatchs() {
        try {
            WatchlistData sysWatch = Resources.sysWatch;
            if (sysWatch != null && sysWatch.hasChild()) {
                this.createMenus(this.menu, this._parent, sysWatch);
                this.sysWatchCreated = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

