/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;

public class DeleteWatchlistAction
implements IViewActionDelegate {
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.view instanceof WatchlistView) {
            Watchlist watchlist = ((WatchlistView)this.view).getWatchlist();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (watchlist.getWatchlistType() == 1) {
                MessageDialog.openError((Shell)window.getShell(), (String)"Delete Watchlist", (String)"System watchlist can't be deleted !");
                return;
            }
            if (MessageDialog.openConfirm((Shell)window.getShell(), (String)"Delete Watchlist", (String)"Do you really want to delete this watchlist ?")) {
                window.getActivePage().hideView(this.view);
                CorePlugin.getRepository().delete((PersistentObject)watchlist);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

