/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading;

import java.util.Map;
import java.util.Observable;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.core.db.Security;

public abstract class TradingSystemPlugin
extends Observable {
    private Account account;
    private Security security;
    private double maxExposure = 0.0;
    private double maxAmount = 0.0;
    private double minAmount = 0.0;
    private int signal = 0;
    private int quantity = 0;

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public double getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(double maxAmountPerTransaction) {
        this.maxAmount = maxAmountPerTransaction;
    }

    public double getMaxExposure() {
        return this.maxExposure;
    }

    public void setMaxExposure(double maxExposure) {
        this.maxExposure = maxExposure;
    }

    public double getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(double minAmountPerTransaction) {
        this.minAmount = minAmountPerTransaction;
    }

    public void setParameters(Map parameters) {
    }

    public abstract void run();

    public int getSignal() {
        return this.signal;
    }

    public void setSignal(int signal) {
        this.signal = signal;
    }

    public int getQuantity() {
        return this.quantity;
    }

    protected void fireOpenLongSignal() {
        PortfolioPosition position = this.getAccount().getPortfolio(this.getSecurity());
        Bar lastQuote = this.getSecurity().getHistory().get(this.getSecurity().getHistory().size() - 1);
        if (position.getQuantity() != 0) {
            this.setSignal(3);
        }
        if (this.maxExposure == 0.0 || position.getValue() < this.maxExposure) {
            double amount = this.maxAmount;
            if (amount == 0.0) {
                amount = this.maxExposure;
            }
            if (amount == 0.0) {
                amount = this.getAccount().getBalance();
            }
            if (this.maxExposure != 0.0 && amount + position.getValue() > this.maxExposure) {
                amount = this.maxExposure - position.getValue();
            }
            if (amount >= this.minAmount && amount <= this.getAccount().getBalance()) {
                this.quantity = (int)(amount / lastQuote.getClose());
                if (this.quantity != 0) {
                    this.setSignal(1);
                    this.setChanged();
                    this.notifyObservers();
                }
            }
        }
    }

    protected void fireCloseLongSignal() {
        PortfolioPosition position = this.getAccount().getPortfolio(this.getSecurity());
        if (position.getQuantity() != 0) {
            this.quantity = position.getQuantity();
            this.setSignal(2);
            this.setChanged();
            this.notifyObservers();
        }
    }
}

