/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ITradingProvider;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.DataCollector;
import pk.com.softech.tradingterminal.trading.TradingSystemPlugin;
import pk.com.softech.tradingterminal.trading.dialogs.PinCodeVerificationDialog;

public class TradingPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "pk.com.softech.tradingterminal.trading";
    public static final String ALERTS_EXTENSION_POINT = "pk.com.softech.tradingterminal.trading.alerts";
    public static final String SYSTEMS_EXTENSION_POINT = "pk.com.softech.tradingterminal.trading.systems";
    public static final String SYSTEM_WIZARDS_EXTENSION_POINT = "pk.com.softech.tradingterminal.trading.systemWizard";
    public static final String PREFS_FOLLOW_SECURITY_SELECTION_BUY = "PREFS_FOLLOW_SECURITY_SELECTION_BUY";
    public static final String PREFS_FOLLOW_SECURITY_SELECTION_QUOTE = "PREFS_FOLLOW_SECURITY_SELECTION_QUOTE";
    public static final String PREFS_DELETE_CANCELED_ORDERS = "DELETE_CANCELED_ORDERS";
    public static final String PREFS_DELETE_CANCELED_ORDERS_DAYS = "DELETE_CANCELED_ORDERS_DAYS";
    public static final String PREFS_DELETE_FILLED_ORDERS = "DELETE_FILLED_ORDERS";
    public static final String PREFS_DELETE_FILLED_ORDERS_DAYS = "DELETE_FILLED_ORDERS_DAYS";
    public static final String PREFS_PIN_CODE = "PIN_CODE";
    public static final String PREFS_SAVE_PIN_CODE = "SAVE_PIN_CODE";
    public static String PREFS_ORDER_VIEW_UPDTED_FEED = "ORDER_VIEW_UPDTED_FEED";
    public static String PREFS_ORDER_VIEW_CLIENT_CODE = "ORDER_VIEW_CLIENT_CODE";
    public static final String IMAGE_UP = "icons/up.gif";
    public static final String IMAGE_DOWN = "icons/down.gif";
    public static final String IMAGE_EQUAL = "icons/equal.gif";
    public static final String IMAGE_WATCHLIST_CUSTOM = "/icons/eview16/book.png";
    public static final String IMAGE_WATCHLIST_SYSTEM = "/icons/eview16/computer.png";
    public static final String IMAGE_WATCHLIST_SPOT = "/icons/eview16/spot.png";
    public static final String IMAGE_WATCHLIST_LOCK = "/icons/eview16/lock.png";
    private static TradingPlugin plugin;
    private DataCollector dataCollector;
    private IPropertyChangeListener feedPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FEED_RUNNING")) {
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    if (TradingPlugin.this.dataCollector == null) {
                        TradingPlugin.this.dataCollector = new DataCollector();
                    }
                } else {
                    if (TradingPlugin.this.dataCollector != null) {
                        TradingPlugin.this.dataCollector.dispose();
                    }
                    TradingPlugin.this.dataCollector = null;
                }
            }
        }
    };

    public TradingPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault(PREFS_FOLLOW_SECURITY_SELECTION_BUY, false);
        CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.feedPropertyListener);
    }

    public void stop(BundleContext context) throws Exception {
        CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.feedPropertyListener);
        super.stop(context);
        plugin = null;
    }

    public static TradingPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static AlertPlugin createAlertPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ALERTS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    try {
                        Object obj = members[i].createExecutableExtension("class");
                        return (AlertPlugin)obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static String getAlertPluginName(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ALERTS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    return item.getAttribute("name");
                }
                ++i;
            }
        }
        return null;
    }

    public static IConfigurationElement[] getAlertPluginPreferencePages(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ALERTS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    return item.getChildren("preferencePage");
                }
                ++i;
            }
        }
        return new IConfigurationElement[0];
    }

    public static List getTradingSystemPlugins() {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(SYSTEMS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                list.add(members[i]);
                ++i;
            }
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s0 = ((IConfigurationElement)arg0).getAttribute("name");
                String s1 = ((IConfigurationElement)arg1).getAttribute("name");
                return s0.compareTo(s1);
            }
        });
        return list;
    }

    public static TradingSystemPlugin createTradingSystemPlugin(TradingSystem system) {
        TradingSystemPlugin plugin = (TradingSystemPlugin)system.getData();
        if (plugin == null) {
            plugin = TradingPlugin.createTradingSystemPlugin(system.getPluginId());
            system.setData((Object)plugin);
        }
        plugin.setAccount(system.getAccount());
        plugin.setSecurity(system.getSecurity());
        plugin.setMaxExposure(system.getMaxExposure());
        plugin.setMinAmount(system.getMinAmount());
        plugin.setMaxAmount(system.getMaxAmount());
        plugin.setParameters(system.getParameters());
        return plugin;
    }

    public static TradingSystemPlugin createTradingSystemPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(SYSTEMS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    try {
                        Object obj = members[i].createExecutableExtension("class");
                        return (TradingSystemPlugin)obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static IConfigurationElement[] getTradingSystemPluginPreferencePages(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(SYSTEMS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    return item.getChildren("preferencePage");
                }
                ++i;
            }
        }
        return new IConfigurationElement[0];
    }

    public static String[] getTradingSystemTradingPluginsList() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("pk.com.softech.tradingterminal.core.tradingProviders");
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            String[] tradingPlugins = new String[members.length];
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                tradingPlugins[i] = item.getAttribute("name");
                ++i;
            }
            return tradingPlugins;
        }
        return null;
    }

    public static ITradingProvider getTradingSystemTradingPlugin(String id) throws Exception {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (id.equals("")) {
            id = Resources.softechTradingProvider;
        }
        if ((extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint("pk.com.softech.tradingterminal.core.tradingProviders")) != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                try {
                    if (item.getAttribute("id").equals(id)) {
                        return (ITradingProvider)item.createExecutableExtension("class");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        throw new RuntimeException("No provider found against id = " + id);
    }

    public boolean pinCodeValidation(String message, String[] values) {
        PinCodeVerificationDialog dlg = new PinCodeVerificationDialog(Display.getCurrent().getActiveShell(), message, values);
        return dlg.open() == 0;
    }

    public static void logException(Exception e) {
        String msg = e.getMessage() == null ? e.toString() : e.getMessage();
        TradingPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
        e.printStackTrace();
    }
}

