/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.IntradayHistory;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class DataCollector
implements Observer,
ICollectionObserver {
    private int minutes = 1;
    private int changes = 15;
    private Map map = new HashMap();
    private Calendar barTime = Calendar.getInstance();
    private Log log = LogFactory.getLog(this.getClass());

    public DataCollector() {
        Security[] items = (Security[])CorePlugin.getRepository().allSecurities().toArray((Object[])new Security[0]);
        int i = 0;
        while (i < items.length) {
            this.itemAdded(items[i]);
            ++i;
        }
        CorePlugin.getRepository().allSecurities().addCollectionObserver((ICollectionObserver)this);
    }

    public void dispose() {
        CorePlugin.getRepository().allSecurities().removeCollectionObserver((ICollectionObserver)this);
        Security[] items = (Security[])CorePlugin.getRepository().allSecurities().toArray((Object[])new Security[0]);
        int i = 0;
        while (i < items.length) {
            this.itemRemoved(items[i]);
            ++i;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Security security = (Security)arg;
        Quote quote = security.getQuote();
        if (!security.isEnableDataCollector() || quote == null || quote.getDate() == null) {
            return;
        }
        this.barTime.setTime(quote.getDate());
        this.barTime.set(13, 0);
        this.barTime.set(14, 0);
        int quoteTime = this.barTime.get(11) * 60 + this.barTime.get(12);
        if (quoteTime < security.getBeginTime() || quoteTime > security.getEndTime()) {
            return;
        }
        MapData data = (MapData)this.map.get(security);
        if (data.bar != null && data.bar.getDate() != null) {
            if (this.barTime.after(data.nextBarTime) || this.barTime.equals(data.nextBarTime)) {
                data.history.add(data.bar);
                if (security.getKeepDays() != 0) {
                    Calendar keepLimit = Calendar.getInstance();
                    keepLimit.setTime(data.bar.getDate());
                    keepLimit.set(10, 0);
                    keepLimit.set(12, 0);
                    keepLimit.set(13, 0);
                    keepLimit.set(14, 0);
                    keepLimit.add(5, -security.getKeepDays());
                    Date limit = keepLimit.getTime();
                    while (data.history.size() > 0 && data.history.get(0).getDate().before(limit)) {
                        data.history.remove(0);
                    }
                }
                try {
                    this.log.trace((Object)("Notifying intraday data updated for " + security.getSymbol() + " - " + security.getDescription()));
                    data.history.notifyObservers();
                    ++data.changes;
                    if (data.changes >= this.changes) {
                        CorePlugin.getRepository().save((PersistentObject)data.history);
                        data.changes = 0;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
                data.bar = null;
            }
        } else if (data.bar == null) {
            data.bar = new Bar();
            data.bar.setOpen(quote.getLast());
            data.bar.setHigh(quote.getLast());
            data.bar.setLow(quote.getLast());
            data.bar.setClose(quote.getLast());
            data.volume = quote.getVolume();
            this.barTime.add(12, -(this.barTime.get(12) % this.minutes));
            data.bar.setDate(this.barTime.getTime());
            data.nextBarTime.setTime(data.bar.getDate());
            data.nextBarTime.add(12, this.minutes);
        }
        if (data.bar != null) {
            if (quote.getLast() > data.bar.getHigh()) {
                data.bar.setHigh(quote.getLast());
            }
            if (quote.getLast() < data.bar.getLow()) {
                data.bar.setLow(quote.getLast());
            }
            data.bar.setClose(quote.getLast());
            data.bar.setVolume(quote.getVolume() - data.volume);
        }
    }

    public void itemAdded(Object o) {
        Security security;
        if (o instanceof Security && this.map.get(security = (Security)o) == null) {
            this.map.put(security, new MapData(security.getIntradayHistory()));
            security.getQuoteMonitor().addObserver((Observer)this);
            this.log.trace((Object)("Added " + security.getDescription() + " with Quote " + security.getQuoteFeed().getId()));
        }
    }

    public void itemRemoved(Object o) {
        Security security;
        MapData data;
        if (o instanceof Security && (data = (MapData)this.map.get(security = (Security)o)) != null) {
            security.getQuoteMonitor().deleteObserver((Observer)this);
            this.map.remove(security);
            if (data.history.size() != 0) {
                CorePlugin.getRepository().save((PersistentObject)data.history);
            }
            this.log.trace((Object)("Removed " + security.getDescription()));
        }
    }

    private class MapData {
        Bar bar;
        IntradayHistory history;
        long volume;
        Calendar nextBarTime;
        int changes;

        MapData(IntradayHistory data) {
            this.history = data;
            this.nextBarTime = Calendar.getInstance();
            this.nextBarTime.set(13, 0);
            this.nextBarTime.set(14, 0);
        }
    }
}

