/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PopupEvent;
import pk.com.softech.tradingterminal.core.db.Security;

public abstract class AlertPlugin {
    private Security security;
    private Date lastSeen;
    private Alert alert;

    public String getDescription() {
        return "";
    }

    public void init(Security security, Alert alert) {
        this.alert = alert;
        this.init(security, alert.getParameters());
    }

    public void init(Security security, Map params) {
        this.security = security;
        this.init(params);
    }

    public void init(Map params) {
    }

    public abstract boolean apply();

    public boolean isSeenToday() {
        if (this.getLastSeen() != null) {
            Calendar today = Calendar.getInstance();
            Calendar last = Calendar.getInstance();
            last.setTime(this.getLastSeen());
            if (today.get(5) == last.get(5) && today.get(2) == last.get(2) && today.get(1) == last.get(1)) {
                return true;
            }
        }
        return false;
    }

    public RGB getHilightBackground() {
        return null;
    }

    public RGB getHilightForeground() {
        return null;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    protected void fireEvent(String message) {
        this.fireEvent(message, "");
    }

    protected void fireEvent(String message, String details) {
        Event event = this.alert != null && this.alert.isPopup() ? new PopupEvent() : new Event();
        event.setSecurity(this.getSecurity());
        event.setLongMessage(message);
        event.setMessage(message);
        CorePlugin.getRepository().save((PersistentObject)event);
    }
}

