/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.DayReportRequest;
import pk.com.softech.messages.DayReportResponse;
import pk.com.softech.messages.GetReportConfigRequest;
import pk.com.softech.messages.ReportConfigData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ReportRequestView
extends ViewPart
implements ICollectionObserver {
    Font font_bold;
    Text txtTo;
    Text txtFrom;
    Text txtUserId;
    Button btnSubmit;
    Button btnClear;
    private Composite parent;
    private static final int LABEL_WIDTH = 50;
    private static final int LABEL_HEIGHT = 20;
    private static final int TEXT_WIDTH_L = 195;
    private static final int TEXT_WIDTH = 100;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 22;
    private static final DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    private static String currentDate;
    public List reportTypeList;
    public Date toDate;
    public Date asOnDate;
    public Date fromDate;
    public String actProgram;
    private String[] lstProgram = null;
    private boolean listenereIntialized = false;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    ScrolledComposite sc;
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.ReportRequestView";
    private Combo cmbReportType;
    private ComboViewer comboViewer;
    private Text txtAsOn;
    private Text txtSymbol;
    private Button setFromDate;
    private Button setToDate;
    private Button setAsOnDate;
    private Label lblSymbol;
    private ReportConfigData curReport;
    private FontMetrics fontMetrics;

    public ReportRequestView() {
        CorePlugin.getRepository().allReportConfigTypes().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    private void clear() {
        this.txtFrom.clearSelection();
        this.txtTo.clearSelection();
        this.txtUserId.setText("");
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CorePlugin.getRepository().allReportConfigTypes().size() <= 0) {
                        GetReportConfigRequest request = new GetReportConfigRequest();
                        if (Resources.getServerLink((String)"", (boolean)true, (boolean)false).writeData((Object)request)) {
                            ReportRequestView.this.logger.info((Object)"Report Types Being Fetched");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        GridData lblGridData = new GridData(50, 20);
        GridData txtGridData = new GridData(100, 15);
        new GridData(195, 15);
        GridData btnGridData = new GridData(100, 22);
        this.sc = new ScrolledComposite(parent, 2816);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite mainComposite = new Composite(composite, 0);
        mainComposite.setLayoutData((Object)new GridData(768));
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridTwoSpan = new GridData();
        gridTwoSpan.grabExcessHorizontalSpace = false;
        gridTwoSpan.horizontalSpan = 2;
        Group grpFilter = new Group(mainComposite, 0);
        grpFilter.setText("Report Filter");
        grpFilter.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).applyTo((Composite)grpFilter);
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)grpFilter);
        Composite compositeL1 = new Composite((Composite)grpFilter, 0);
        Composite compositeL11 = new Composite((Composite)grpFilter, 0);
        Composite compositeL2 = new Composite((Composite)grpFilter, 0);
        Composite compositeL3 = new Composite((Composite)grpFilter, 0);
        compositeL1.setLayoutData((Object)new GridData(768));
        compositeL1.setLayout((Layout)new GridLayout(8, false));
        compositeL11.setLayoutData((Object)new GridData(768));
        compositeL11.setLayout((Layout)new GridLayout(4, false));
        compositeL2.setLayoutData((Object)new GridData(768));
        compositeL2.setLayout((Layout)new GridLayout(6, false));
        compositeL3.setLayoutData((Object)new GridData(768));
        compositeL3.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(compositeL1, "Client Code", lblGridData);
        this.txtUserId = this.createText(compositeL1, 16384, txtGridData);
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.createLabel(compositeL1, "Report Type", lblGridData);
        this.comboViewer = new ComboViewer(compositeL1, 0);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ReportConfigData)element).getReportName();
            }
        });
        this.cmbReportType = this.comboViewer.getCombo();
        this.cmbReportType.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.cmbReportType.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selectionObject = (IStructuredSelection)event.getSelection();
                Object o = selectionObject.getFirstElement();
                ReportRequestView.this.curReport = (ReportConfigData)o;
                ReportRequestView.this.applyFilters(ReportRequestView.this.curReport);
            }
        });
        this.lblSymbol = this.createLabel(compositeL11, "Symbol", lblGridData);
        this.txtSymbol = this.createText(compositeL11, 16384, txtGridData);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtAsOn = this.createText(compositeL11, 16384, txtGridData);
        this.txtAsOn.setEnabled(false);
        this.setAsOnDate = new Button(compositeL11, 8);
        this.setAsOnDate.setText("As On Date");
        this.txtFrom = this.createText(compositeL2, 16384, txtGridData);
        this.txtFrom.setEnabled(false);
        this.setFromDate = new Button(compositeL2, 8);
        this.setFromDate.setText("From Date");
        this.txtTo = this.createText(compositeL2, 16384, txtGridData);
        this.txtTo.setEnabled(false);
        this.setToDate = new Button(compositeL2, 8);
        this.setToDate.setText("To Date");
        this.txtAsOn.setVisible(false);
        this.txtFrom.setVisible(false);
        this.txtTo.setVisible(false);
        this.setAsOnDate.setVisible(false);
        this.setFromDate.setVisible(false);
        this.setToDate.setVisible(false);
        this.lblSymbol.setVisible(false);
        this.txtSymbol.setVisible(false);
        this.btnSubmit = this.createButton(compositeL1, "Submit", btnGridData);
        this.btnSubmit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String userId = (this).ReportRequestView.this.txtUserId.getText();
                            if (userId == null || "".equalsIgnoreCase(userId) || ReportRequestView.this.curReport == null) {
                                (this).ReportRequestView.this.btnSubmit.setEnabled(true);
                                MessageDialog.openError(null, (String)"Report Request", (String)"Please Fill Filter Data Properly.");
                                (this).ReportRequestView.this.txtUserId.setFocus();
                                return;
                            }
                            (this).ReportRequestView.this.btnSubmit.setEnabled(false);
                            ReportRequestView.this.submitUserRequest();
                        }
                        catch (Exception ex) {
                            (this).ReportRequestView.this.btnSubmit.setEnabled(true);
                            ex.printStackTrace();
                        }
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ReportRequestView.this.listenereIntialized) {
                    ReportRequestView.this.initializeListeners();
                    ReportRequestView.this.listenereIntialized = true;
                }
                ReportRequestView.this.comboViewer.setInput((Object)CorePlugin.getRepository().allReportConfigTypes());
                if (Resources.userType != 3 && Resources.userType != 0) {
                    ReportRequestView.this.txtUserId.setText(Resources.userId);
                }
            }
        });
        this.sc.setContent((Control)composite);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(composite.computeSize(-1, -1));
    }

    private void submitUserRequest() {
        DayReportRequest drequest = new DayReportRequest();
        drequest.setClientCode(this.txtUserId.getText());
        drequest.setReportType(this.curReport.getReportCode());
        List filters = this.curReport.getRequiredFilters();
        if (filters != null) {
            DayReportRequest.DateRange range = drequest.getRange();
            for (ReportConfigData.Filters filter : filters) {
                switch (filter) {
                    case FROM_DATE: {
                        if (this.fromDate != null) {
                            range.setFromDate(this.fromDate);
                            break;
                        }
                        this.btnSubmit.setEnabled(true);
                        MessageDialog.openInformation(null, (String)"Error", (String)"From date filter is not provided");
                        return;
                    }
                    case TO_DATE: {
                        if (this.toDate != null) {
                            range.setToDate(this.toDate);
                            break;
                        }
                        this.btnSubmit.setEnabled(true);
                        MessageDialog.openInformation(null, (String)"Error", (String)"To date filter is not provided");
                        return;
                    }
                    case AS_ON_DATE: {
                        if (this.asOnDate != null) {
                            range.setAsOnDate(this.asOnDate);
                            break;
                        }
                        this.btnSubmit.setEnabled(true);
                        MessageDialog.openInformation(null, (String)"Error", (String)"As On date filter is not provided");
                        return;
                    }
                    case SYMBOL: {
                        String sym = this.txtSymbol.getText();
                        if (sym != null || "".equalsIgnoreCase(sym)) {
                            drequest.setSymbol(sym);
                            break;
                        }
                        this.btnSubmit.setEnabled(true);
                        MessageDialog.openInformation(null, (String)"Error", (String)"Symbol filter is not provided");
                        return;
                    }
                    default: {
                        this.btnSubmit.setEnabled(true);
                        return;
                    }
                }
            }
        }
        if (Resources.getServerLink((String)"", (boolean)true, (boolean)false).writeData((Object)drequest)) {
            this.logger.info((Object)"Day Report Request Sent!");
        } else {
            this.btnSubmit.setEnabled(true);
        }
    }

    private void applyFilters(ReportConfigData obj) {
        this.clearFields();
        List enumfilter = obj.getRequiredFilters();
        if (enumfilter != null) {
            this.enableFilters(enumfilter);
        }
    }

    private void enableFilters(List<ReportConfigData.Filters> filters) {
        block6: for (ReportConfigData.Filters filter : filters) {
            switch (filter) {
                case FROM_DATE: {
                    this.txtFrom.setVisible(true);
                    this.setFromDate.setVisible(true);
                    if (this.fromDate == null) continue block6;
                    String dateF = df.format(this.fromDate);
                    this.txtFrom.setText(dateF);
                    break;
                }
                case TO_DATE: {
                    this.txtTo.setVisible(true);
                    this.setToDate.setVisible(true);
                    if (this.toDate == null) continue block6;
                    String dateT = df.format(this.toDate);
                    this.txtTo.setText(dateT);
                    break;
                }
                case AS_ON_DATE: {
                    this.txtAsOn.setVisible(true);
                    this.setAsOnDate.setVisible(true);
                    if (this.fromDate == null) continue block6;
                    String dateA = df.format(this.fromDate);
                    this.txtAsOn.setText(dateA);
                    break;
                }
                case SYMBOL: {
                    this.txtSymbol.setVisible(true);
                    this.lblSymbol.setVisible(true);
                    break;
                }
                default: {
                    this.clearFields();
                }
            }
        }
    }

    private void clearFields() {
        this.txtAsOn.setText("");
        this.txtTo.setText("");
        this.txtFrom.setText("");
        this.txtSymbol.setText("");
        this.txtFrom.setVisible(false);
        this.setFromDate.setVisible(false);
        this.txtTo.setVisible(false);
        this.setToDate.setVisible(false);
        this.txtAsOn.setVisible(false);
        this.setAsOnDate.setVisible(false);
        this.txtSymbol.setVisible(false);
        this.lblSymbol.setVisible(false);
    }

    private void receiveReportTypes(ReportConfigData obj) {
        if (obj != null) {
            this.comboViewer.add((Object)obj);
        }
    }

    private void receiveReportSubmit(DayReportResponse obj) {
        this.btnSubmit.setEnabled(true);
        if (obj != null) {
            if (obj.getStatus() == 1) {
                MessageDialog.openInformation(null, (String)"Info", (String)obj.getMessage());
            } else {
                MessageDialog.openError(null, (String)"Error", (String)obj.getMessage());
            }
        }
    }

    private Label createLabel(Composite parent, String label, GridData gridData) {
        Label temp = new Label(parent, 1);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment, GridData gridData) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(true);
        return temp;
    }

    private Button createButton(Composite parent, String label, GridData gridData) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    private Combo createCombo(Composite parent, GridData gridData) {
        Combo cmbUserType = new Combo(parent, 2048);
        return cmbUserType;
    }

    private void initializeListeners() {
        Calendar calendar = Calendar.getInstance();
        df.format(calendar.getTime());
        this.toDate = calendar.getTime();
        calendar.add(5, -Resources.maxReportDaysLimit);
        this.asOnDate = this.fromDate = calendar.getTime();
        final int maxReports = Resources.maxReportDaysLimit >= 0 ? Resources.maxReportDaysLimit : 0;
        this.setFromDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = ReportRequestView.this.covertStringToDate(currentDate);
                        Date fDate = ReportRequestView.this.covertStringToDate(dateString);
                        if (fDate.compareTo(cDate) < 1 && fDate.compareTo(cDate) != 0) {
                            (this).ReportRequestView.this.txtFrom.setText(dateString);
                            (this).ReportRequestView.this.fromDate = fDate;
                            dialog.close();
                        } else {
                            (this).ReportRequestView.this.fromDate = null;
                            MessageDialog.openError(null, (String)"Not Allowed", (String)"From date filter is not allowed to the current date");
                            (this).ReportRequestView.this.txtFrom.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.setToDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = ReportRequestView.this.covertStringToDate(currentDate);
                        Date tDate = ReportRequestView.this.covertStringToDate(dateString);
                        if (tDate.compareTo(cDate) < 1 || tDate.compareTo(cDate) == 0) {
                            if ((this).ReportRequestView.this.fromDate != null) {
                                long diffInMillies = Math.abs(tDate.getTime() - (this).ReportRequestView.this.fromDate.getTime());
                                long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) + 1L;
                                if (diff >= (long)maxReports) {
                                    (this).ReportRequestView.this.txtTo.setText(dateString);
                                    (this).ReportRequestView.this.toDate = tDate;
                                    dialog.close();
                                } else if (diff <= (long)maxReports) {
                                    diff = (long)maxReports - diff;
                                    MessageDialog.openInformation(null, (String)"Not Allowed", (String)("Please Skip days : " + diff + "  in From Date filter or Increase Days in To Date Filter to place report request, Else See in the Report Section for this report range"));
                                    (this).ReportRequestView.this.txtTo.setText("");
                                    dialog.close();
                                    (this).ReportRequestView.this.toDate = null;
                                }
                            } else {
                                MessageDialog.openInformation(null, (String)"Information", (String)"Please select from date filter first.");
                                (this).ReportRequestView.this.txtTo.setText("");
                                dialog.close();
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid date selection , To date filter less then the current date");
                            (this).ReportRequestView.this.txtTo.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.setAsOnDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = ReportRequestView.this.covertStringToDate(currentDate);
                        Date asDate = ReportRequestView.this.covertStringToDate(dateString);
                        long diffInMillies = Math.abs(cDate.getTime() - asDate.getTime());
                        long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) + 1L;
                        if (diff >= (long)maxReports) {
                            ReportRequestView.this.txtAsOn.setText(dateString);
                            (this).ReportRequestView.this.asOnDate = asDate;
                            dialog.close();
                        } else if (diff <= (long)maxReports) {
                            diff = (long)maxReports - diff;
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)("Please Skip days : " + diff + "  in As On Date filter to place report request, Else See in the Report Section for this report range"));
                            ReportRequestView.this.txtAsOn.setText("");
                            (this).ReportRequestView.this.asOnDate = null;
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ReportConfigData) {
                        ReportConfigData rsp = (ReportConfigData)o;
                        ReportRequestView.this.receiveReportTypes(rsp);
                        if (!ReportRequestView.this.listenereIntialized) {
                            ReportRequestView.this.initializeListeners();
                            ReportRequestView.this.listenereIntialized = true;
                        }
                    } else if (o instanceof DayReportResponse) {
                        DayReportResponse res = (DayReportResponse)o;
                        ReportRequestView.this.receiveReportSubmit(res);
                        ReportRequestView.this.btnSubmit.setEnabled(true);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().allReportConfigTypes().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public Date covertStringToDate(String str) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = df.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setFocus() {
    }
}

