/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JEditorPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.Rotation;
import pk.com.softech.messages.ClientDlgInfo;
import pk.com.softech.messages.ClientDlgRequest;
import pk.com.softech.messages.ClientDlgResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.reports.views.BaseReport;
import pk.com.softech.util.Utility;

public class PortfolioSummaryView
extends BaseReport
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.PortfolioSummaryView";
    public static final String PORTFOLIO_SUMMARY_VIEW_COLUMNS_SIZE = "PORTFOLIO_SUMMARY_VIEW_COLUMNS_SIZE";
    private static final int LABEL_WIDTH = 75;
    private static final int LABEL_HEIGHT = 19;
    private static final int BUTTON_WIDTH = 75;
    private static final int BUTTON_HEIGHT = 22;
    private static final int TEXT_WIDTH = 75;
    private static final int TEXT_HEIGHT = 15;
    DecimalFormat df = new DecimalFormat("##.##");
    int sortColumn = 0;
    int sortDirection = 1;
    private Text txtClientCodeSearch;
    private Text txtClientNameSearch;
    private Group cmpWest;
    private Label lblClientCode;
    private Label lblAsOnDate;
    private Text txtAsOnDate;
    Button btnRefresh;
    public static final int CLIENTCODE = 0;
    public static final int CLIENTNAME = 1;
    private static String[] COLUMN_NAMES = new String[]{"Client Code", "Client Name"};
    private ClientFilter filter;
    private JFreeChart tempChart;
    private JFreeChart chart;
    Composite content;
    Composite content1;
    public static final String PREFS_SORT_COLUMN = "CLIENTLISTING_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "CLIENTLISTING_SORT_DIRECTION";
    protected Log logger = LogFactory.getLog(this.getClass());
    Font font_bold;
    private TableViewer viewer;
    Table table_acc = null;
    private SecurityComparator comparator;
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < PortfolioSummaryView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(PortfolioSummaryView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(PortfolioSummaryView.PORTFOLIO_SUMMARY_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = PortfolioSummaryView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (PortfolioSummaryView.this.sortColumn == index) {
                PortfolioSummaryView.this.sortDirection = PortfolioSummaryView.this.sortDirection == 0 ? 1 : 0;
            } else {
                PortfolioSummaryView.this.sortColumn = index;
                PortfolioSummaryView.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(PortfolioSummaryView.PREFS_SORT_COLUMN, PortfolioSummaryView.this.sortColumn);
            prefs.setValue(PortfolioSummaryView.PREFS_SORT_DIRECTION, PortfolioSummaryView.this.sortDirection);
            PortfolioSummaryView.this.viewer.getTable().setSortColumn(PortfolioSummaryView.this.viewer.getTable().getColumn(PortfolioSummaryView.this.sortColumn));
            PortfolioSummaryView.this.viewer.getTable().setSortDirection(PortfolioSummaryView.this.sortDirection == 0 ? 128 : 1024);
            PortfolioSummaryView.this.comparator.setColumn(PortfolioSummaryView.this.sortColumn);
            PortfolioSummaryView.this.viewer.refresh();
        }
    };

    public PortfolioSummaryView() {
        this.df.setMinimumFractionDigits(2);
        this.df.setMinimumIntegerDigits(2);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        this.cmpWest = new Group(parent, 0);
        this.cmpWest.setText("Filter");
        this.cmpWest.setFont(this.font_bold);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.cmpWest.setLayout((Layout)gridLayout);
        this.showClientList(Resources.isClientType());
        this.createLabel((Composite)this.cmpWest, "Client Code");
        this.txtClientCodeSearch = this.createText((Composite)this.cmpWest, 16384);
        this.txtClientCodeSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCodeSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                PortfolioSummaryView.this.filter.setSearchText(PortfolioSummaryView.this.txtClientCodeSearch.getText(), PortfolioSummaryView.this.txtClientNameSearch.getText());
                PortfolioSummaryView.this.viewer.refresh();
            }
        });
        this.createLabel((Composite)this.cmpWest, "Client Name");
        this.txtClientNameSearch = this.createText((Composite)this.cmpWest, 16384);
        this.txtClientNameSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientNameSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                PortfolioSummaryView.this.filter.setSearchText(PortfolioSummaryView.this.txtClientCodeSearch.getText(), PortfolioSummaryView.this.txtClientNameSearch.getText());
                PortfolioSummaryView.this.viewer.refresh();
            }
        });
        this.btnRefresh = new Button((Composite)this.cmpWest, 0x1000000);
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PortfolioSummaryView.this.clearFields();
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    PortfolioSummaryView.this.sendClientListingRequest();
                    PortfolioSummaryView.this.filter.setSearchText(PortfolioSummaryView.this.txtClientCodeSearch.getText(), PortfolioSummaryView.this.txtClientNameSearch.getText());
                    PortfolioSummaryView.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer((Composite)this.cmpWest);
        this.comparator = new SecurityComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        try {
            this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
            this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
            this.comparator.setColumn(this.sortColumn);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.filter = new ClientFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.btnRefresh.setEnabled(!Resources.isClientType());
        Composite cmpEast = new Composite(parent, 0);
        cmpEast.setLayout((Layout)new GridLayout(6, false));
        FormData data2 = new FormData();
        data2.top = new FormAttachment(0, 5);
        data2.bottom = new FormAttachment(100, -5);
        data2.right = new FormAttachment(100, 0);
        data2.left = new FormAttachment((Control)this.cmpWest, 5);
        cmpEast.setLayoutData((Object)data2);
        this.lblClientCode = new Label(cmpEast, 0);
        this.lblClientCode.setText("Client Code:");
        this.lblClientCode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtClientCode = new Text(cmpEast, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    String clientCode = "";
                    clientCode = PortfolioSummaryView.this.txtClientCode.isEnabled() ? PortfolioSummaryView.this.txtClientCode.getText() : Resources.clientId;
                    if (Resources.isServerConnected((String)clientCode, (boolean)true, (boolean)true)) {
                        PortfolioSummaryView.this.sendReportRequest();
                    }
                }
            }
        });
        this.lblAsOnDate = new Label(cmpEast, 0);
        this.lblAsOnDate.setText("As On Date:");
        this.lblAsOnDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtAsOnDate = new Text(cmpEast, 2048);
        this.txtAsOnDate.setText(pk.com.softech.tradingterminal.core.Utility.getCurrentDate());
        this.txtAsOnDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtAsOnDate.addKeyListener(this.enterKeylistener);
        if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            this.txtAsOnDate.setEnabled(false);
        } else {
            this.txtAsOnDate.setEnabled(true);
        }
        this.btnFetch = new Button(cmpEast, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String clientCode = "";
                clientCode = PortfolioSummaryView.this.txtClientCode.isEnabled() ? PortfolioSummaryView.this.txtClientCode.getText() : Resources.clientId;
                if (Resources.isServerConnected((String)clientCode, (boolean)true, (boolean)false)) {
                    PortfolioSummaryView.this.sendReportRequest();
                }
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(cmpEast, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortfolioSummaryView.this.editor.setText(PortfolioSummaryView.this.browser.getText());
                PortfolioSummaryView.this.rp.print(PortfolioSummaryView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 8;
        databrows.widthHint = 500;
        this.browser = new Browser(cmpEast, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
        this.editor = new JEditorPane();
        this.editor.setContentType("text/html");
        this.editor.setEditable(false);
        this.editor.setVisible(false);
        if (Resources.loginStatus) {
            if (!Resources.isClientType()) {
                this.sendClientListingRequest();
            } else {
                this.sendReportRequest();
            }
        }
    }

    private void showClientList(boolean clientType) {
        if (clientType) {
            FormData data1 = new FormData();
            data1.top = new FormAttachment(0, 5);
            data1.bottom = new FormAttachment(100, -5);
            data1.right = new FormAttachment(0, 0);
            data1.left = new FormAttachment(0, 0);
            this.cmpWest.setLayoutData((Object)data1);
        } else {
            FormData data1 = new FormData();
            data1.top = new FormAttachment(0, 5);
            data1.bottom = new FormAttachment(100, -5);
            data1.right = new FormAttachment(20, 0);
            data1.left = new FormAttachment(0, 0);
            this.cmpWest.setLayoutData((Object)data1);
        }
        this.parent.layout();
    }

    private void clearFields() {
        this.txtClientCodeSearch.setText("");
        this.txtClientNameSearch.setText("");
    }

    private void sendClientListingRequest() {
        if (!Resources.isClientType()) {
            try {
                ClientDlgRequest request = new ClientDlgRequest();
                if (!Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request)) {
                    MessageDialog.openError(null, (String)"Connection Error", (String)"You seem to be disconnected from the server. \n Please re-connect again from the file menu.");
                }
            }
            catch (Exception exc) {
                this.logger.error((Object)"", (Throwable)exc);
            }
        } else {
            this.viewer.setInput(new ArrayList());
        }
    }

    @Override
    public void sendReportRequest() {
        String clientCode = "";
        Date fDate = pk.com.softech.tradingterminal.core.Utility.getDate((String)this.txtAsOnDate.getText());
        clientCode = this.txtClientCode.isEnabled() ? this.txtClientCode.getText() : Resources.clientId;
        if (fDate == null) {
            MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid from date");
        } else {
            ReportRequest rt = new ReportRequest(13, clientCode, fDate, fDate);
            if (this.btnFetch.isEnabled() && Resources.isServerConnected((String)clientCode.trim(), (boolean)true, (boolean)false) && Resources.getServerLink((String)clientCode.trim(), (boolean)true, (boolean)false).writeData((Object)rt)) {
                this.btnFetch.setEnabled(false);
                this.logger.info((Object)("sending report request " + rt.getReportType()));
            }
        }
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 2176);
        temp.setEnabled(!Resources.isClientType());
        return temp;
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof LoginConfirmation) {
                        PortfolioSummaryView.this.btnRefresh.setEnabled(!Resources.isClientType());
                        PortfolioSummaryView.this.txtClientCode.setText(Resources.clientId);
                        PortfolioSummaryView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        PortfolioSummaryView.this.txtClientCodeSearch.setEnabled(!Resources.isClientType());
                        PortfolioSummaryView.this.txtClientNameSearch.setEnabled(!Resources.isClientType());
                        PortfolioSummaryView.this.showClientList(Resources.isClientType());
                        if (Resources.isClientType()) {
                            PortfolioSummaryView.this.sendReportRequest();
                        } else {
                            PortfolioSummaryView.this.sendClientListingRequest();
                        }
                    }
                    if (o instanceof ClientDlgResponse) {
                        ClientDlgResponse rsp2 = (ClientDlgResponse)o;
                        PortfolioSummaryView.this.recieveClientDlgResponse(rsp2);
                    } else if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 13) {
                        PortfolioSummaryView.this.recieveReportResponse(rsp);
                        PortfolioSummaryView.this.btnFetch.setEnabled(true);
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    public void recieveClientDlgResponse(final ClientDlgResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ClientDlgInfo> list = new ArrayList<ClientDlgInfo>();
                    if (resp.getRows() != null) {
                        int i = 0;
                        while (i < resp.getRows().length) {
                            ClientDlgInfo temp = resp.getRows()[i];
                            list.add(new ClientDlgInfo(temp.getClientCode().toUpperCase(), temp.getClientName().toUpperCase(), temp.getClientLot().toUpperCase(), temp.getMobileNo(), temp.getMaidenName(), temp.getPinCode(), temp.getAddress().toUpperCase(), temp.getIdCardNo(), temp.getEmail(), temp.getClientGroup(), temp.getTraderCode()));
                            ++i;
                        }
                        PortfolioSummaryView.this.viewer.setInput(list);
                    }
                }
            });
        }
    }

    @Override
    public void recieveReportResponse(final ReportResponse resp) {
        this.browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (resp.getHTML() == null) {
                        PortfolioSummaryView.this.browser.setText("Report not available");
                    } else {
                        String html = resp.getHTML();
                        int fontSize = 1;
                        try {
                            fontSize = PortfolioSummaryView.this.prefrences.getInt("REPORTS_FONT");
                        }
                        catch (Exception exception) {}
                        if (html != null && fontSize != 1) {
                            html = html.replaceAll("font size=2", "font size=" + fontSize);
                        }
                        Hashtable hashtable = resp.getChartValues();
                        DefaultPieDataset data = new DefaultPieDataset();
                        ArrayList myArrayList = new ArrayList(hashtable.entrySet());
                        Collections.sort(myArrayList, new MyComparator());
                        Iterator itr = myArrayList.iterator();
                        String key = "";
                        double value = 0.0;
                        double others = 0.0;
                        int cnt = 0;
                        int symbolLength = 15;
                        while (itr.hasNext()) {
                            Map.Entry e = itr.next();
                            key = (String)e.getKey();
                            value = (Double)e.getValue();
                            if (++cnt <= 5) {
                                String temp = String.valueOf(Utility.padRight((String)key, (int)symbolLength)) + " " + PortfolioSummaryView.this.df.format(value) + "%";
                                data.setValue((Comparable)((Object)temp), value);
                                continue;
                            }
                            others += value;
                        }
                        if (cnt > 5) {
                            data.setValue((Comparable)((Object)(String.valueOf(Utility.padRight((String)"Others", (int)symbolLength)) + " " + PortfolioSummaryView.this.df.format(others) + "%")), others);
                        }
                        PortfolioSummaryView.this.chart = PortfolioSummaryView.this.createChart((PieDataset)data);
                        PortfolioSummaryView.this.chart.getLegend().setPosition(RectangleEdge.RIGHT);
                        try {
                            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                            File f1 = new File(Platform.getLocation().toFile(), "piechart.png");
                            ChartUtilities.saveChartAsPNG((File)f1, (JFreeChart)PortfolioSummaryView.this.chart, (int)500, (int)300, (ChartRenderingInfo)info);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            File f2 = new File(Platform.getLocation().toFile(), "piechart.png");
                            URL url = f2.toURL();
                            html = String.valueOf(html) + "<p align=center><img src=\"" + url + "\" width=500 height=300 /></p></body></html>";
                            PortfolioSummaryView.this.editor.setText(html);
                            PortfolioSummaryView.this.editor.setCaretPosition(0);
                            PortfolioSummaryView.this.editor.setVisible(true);
                            PortfolioSummaryView.this.btnFetch.setEnabled(true);
                        }
                        catch (Exception e) {
                            PortfolioSummaryView.this.logger.error((Object)"", (Throwable)e);
                        }
                        PortfolioSummaryView.this.browser.setText(html);
                    }
                    PortfolioSummaryView.this.btnPrint.setEnabled(true);
                }
                catch (Exception e) {
                    PortfolioSummaryView.this.logger.info((Object)("Exception occured in Recieve Portfolio Summary Report" + e));
                }
                PortfolioSummaryView.this.browser.setVisible(true);
            }
        });
    }

    private JFreeChart createChart(PieDataset dataset) {
        this.tempChart = ChartFactory.createPieChart((String)" Portfolio Weight                          ", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        this.tempChart.setBackgroundPaint((Paint)Color.WHITE);
        this.tempChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        PiePlot plot = (PiePlot)this.tempChart.getPlot();
        plot.setDataset(dataset);
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        plot.setLabelGenerator(null);
        return this.tempChart;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68356);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String clientCode = "";
                TableItem[] items = PortfolioSummaryView.this.viewer.getTable().getSelection();
                ClientDlgInfo info = (ClientDlgInfo)items[0].getData();
                clientCode = info.getClientCode().trim();
                PortfolioSummaryView.this.txtClientCode.setText(clientCode);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PORTFOLIO_SUMMARY_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientCode().toUpperCase());
                        break;
                    }
                    case 1: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientName().toUpperCase());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientName();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    class ClientFilter
    extends ViewerFilter {
        private String clientCode;
        private String clientName;

        ClientFilter() {
        }

        public void setSearchText(String s1, String s2) {
            this.clientCode = ".*" + s1 + ".*";
            this.clientName = ".*" + s2 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.clientName == null || this.clientName.length() == 0) {
                return true;
            }
            if (this.clientCode == null || this.clientCode.length() == 0) {
                return true;
            }
            ClientDlgInfo p = (ClientDlgInfo)element;
            if (p.clientName == null) {
                p.clientName = "";
            }
            if (p.clientCode == null) {
                p.clientCode = "";
            }
            return p.getClientName().matches(this.clientName) && p.getClientCode().matches(this.clientCode);
        }
    }

    static class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Double value2;
            int result = 0;
            Map.Entry e1 = (Map.Entry)obj1;
            Map.Entry e2 = (Map.Entry)obj2;
            Double value1 = (Double)e1.getValue();
            if (value1.compareTo(value2 = (Double)e2.getValue()) == 0) {
                String word1 = (String)e1.getKey();
                String word2 = (String)e2.getKey();
                result = word1.compareToIgnoreCase(word2);
            } else {
                result = value2.compareTo(value1);
            }
            return result;
        }
    }

    class SecurityComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ClientDlgInfo p1 = (ClientDlgInfo)e1;
            ClientDlgInfo p2 = (ClientDlgInfo)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 1: {
                    rc = p1.getClientName().compareTo(p2.getClientName());
                    break;
                }
                case 0: {
                    rc = p1.getClientCode().compareTo(p2.getClientCode());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

