/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.ClearingTypeResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class PeriodicDetailView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.PeriodicDetailView";
    private static final int VIEW_WIDTH = 800;
    private Text txtFromDate;
    private Text txtToDate;
    private Combo cmbClearType;
    private Combo cmbExchange;
    private Text txtSymbol;
    private Label lblFromDate;
    private Label lblToDate;
    private Label lblClearType;
    private Label lblExchange;
    private Label lblSymbol;

    @Override
    public void createPartControl(Composite parent) {
        int i;
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite content = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(7).equalWidth(false).applyTo(content);
        GridDataFactory.fillDefaults().grab(false, true).hint(800, -1).applyTo((Control)content);
        this.lblClientCode = new Label(content, 0);
        this.lblClientCode.setText("Client Code:");
        this.txtClientCode = new Text(content, 2048);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener(this.enterKeylistener);
        this.lblFromDate = new Label(content, 0);
        this.lblFromDate.setText("From Date:");
        this.txtFromDate = new Text(content, 2048);
        this.txtFromDate.setText(Utility.getCurrentDate());
        this.txtFromDate.addKeyListener(this.enterKeylistener);
        this.lblToDate = new Label(content, 0);
        this.lblToDate.setText("To Date:");
        this.txtToDate = new Text(content, 2048);
        this.txtToDate.setText(Utility.getCurrentDate());
        this.txtToDate.addKeyListener(this.enterKeylistener);
        this.btnPrint = new Button(content, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeriodicDetailView.this.editor.setText(PeriodicDetailView.this.browser.getText());
                PeriodicDetailView.this.rp.print(PeriodicDetailView.this.editor);
            }
        });
        this.lblExchange = new Label(content, 0);
        this.lblExchange.setText("Exchange:");
        this.cmbExchange = new Combo(content, 2048);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            this.cmbExchange.add("All");
            i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.lblClearType = new Label(content, 0);
        this.lblClearType.setText("Clearing Type:");
        this.cmbClearType = new Combo(content, 2056);
        if (Resources.clearingTypes != null) {
            this.cmbClearType.removeAll();
            i = 0;
            while (i < Resources.clearingTypes.size()) {
                this.cmbClearType.add((String)Resources.clearingTypes.get(i));
                ++i;
            }
            this.cmbClearType.select(0);
        }
        this.lblSymbol = new Label(content, 0);
        this.lblSymbol.setText("Symbol:");
        this.txtSymbol = new Text(content, 2048);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addKeyListener(this.enterKeylistener);
        this.btnFetch = new Button(content, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeriodicDetailView.this.sendReportRequest();
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 7;
        databrows.widthHint = 800;
        this.browser = new Browser(content, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
        sc.setContent((Control)content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(content.computeSize(-1, -1));
    }

    @Override
    void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            String clear_code = Resources.clearingTypeCodes.get(Resources.clearingTypes.indexOf(this.cmbClearType.getText())).toString();
            String exchangeCode = this.cmbExchange.getText().equals("All") ? "%" : Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbExchange.getText())).toString();
            String symbol = this.txtSymbol.getText().trim();
            Date tDate = Utility.getDate((String)this.txtToDate.getText());
            Date fDate = Utility.getDate((String)this.txtFromDate.getText());
            if (fDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid from date");
            } else if (tDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid to date");
            } else if (exchangeCode == null || exchangeCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Exchange is invalid");
            } else if (clear_code == null || clear_code.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Clearing type is invalid");
            } else {
                ReportRequest rt = new ReportRequest(1, clientCode, fDate, tDate, symbol, clear_code);
                rt.setStExCode(exchangeCode);
                super.sendReportRequest(clientCode, rt, false);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 1) {
                        PeriodicDetailView.this.recieveReportResponse(rsp);
                        PeriodicDetailView.this.logger.info((Object)"response recieved ReportResponse.PERIODIC_TRADE_DETAIL");
                    }
                    if (o instanceof LoginConfirmation) {
                        PeriodicDetailView.this.txtClientCode.setText(Resources.clientId);
                        PeriodicDetailView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        if (Resources.exchangeNames != null) {
                            PeriodicDetailView.this.cmbExchange.removeAll();
                            PeriodicDetailView.this.cmbExchange.add("All");
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                PeriodicDetailView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            PeriodicDetailView.this.cmbExchange.select(0);
                        }
                    }
                    if (o instanceof ClearingTypeResponse && Resources.clearingTypes != null) {
                        PeriodicDetailView.this.cmbClearType.removeAll();
                        int i = 0;
                        while (i < Resources.clearingTypes.size()) {
                            PeriodicDetailView.this.cmbClearType.add((String)Resources.clearingTypes.get(i));
                            ++i;
                        }
                        PeriodicDetailView.this.cmbClearType.select(0);
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

