/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class OutstandingOrderView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.OutstandingOrderView";
    private Label lblExchange;
    private Combo cmbExchange;
    private Text txtSubCode;
    private Text txtSymbol;
    private Label lblSubCode;

    @Override
    public void createPartControl(Composite outstandingOrder) {
        this.parent = outstandingOrder;
        GridLayout gridContents = new GridLayout(10, false);
        outstandingOrder.setLayout((Layout)gridContents);
        super.createPartControl(outstandingOrder);
        new Label(this.parent, 0).setText("Symbol");
        this.txtSymbol = new Text(this.parent, 2048);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.setLayoutData((Object)new GridData(80, -1));
        this.txtSymbol.addKeyListener(this.enterKeylistener);
        this.lblSubCode = new Label(this.parent, 0);
        this.lblSubCode.setText("Sub Code");
        this.lblSubCode.setVisible(Resources.isMemberTerminal());
        this.txtSubCode = new Text(this.parent, 2048);
        this.txtSubCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSubCode.setLayoutData((Object)new GridData(80, -1));
        this.txtSubCode.addKeyListener(this.enterKeylistener);
        this.txtSubCode.setVisible(Resources.isMemberTerminal());
        this.lblExchange = new Label(this.parent, 0);
        this.lblExchange.setText("Exchange:");
        this.lblExchange.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.cmbExchange = new Combo(this.parent, 2056);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            this.cmbExchange.add("All");
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.btnFetch = new Button(outstandingOrder, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutstandingOrderView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(outstandingOrder, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutstandingOrderView.this.editor.setText(OutstandingOrderView.this.browser.getText());
                OutstandingOrderView.this.rp.print(OutstandingOrderView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 10;
        databrows.widthHint = 500;
        this.browser = new Browser(outstandingOrder, 0);
        this.browser.setVisible(false);
        this.browser.setLayoutData((Object)databrows);
    }

    @Override
    public void sendReportRequest() {
        String exchangeCode = "";
        try {
            String clientCode = this.txtClientCode.getText().trim();
            exchangeCode = this.cmbExchange.getText().equals("All") ? "%" : Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbExchange.getText())).toString();
            if (exchangeCode == null || exchangeCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Exchange is invalid");
            } else {
                ReportRequest rt = new ReportRequest(10, clientCode, this.txtSubCode.getText().trim());
                rt.setSymbol(this.txtSymbol.getText().trim());
                rt.setStExCode(exchangeCode);
                super.sendReportRequest(clientCode, rt, false);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 10) {
                        OutstandingOrderView.this.recieveReportResponse(rsp);
                    }
                    if (o instanceof LoginConfirmation) {
                        OutstandingOrderView.this.txtClientCode.setText(Resources.clientId);
                        OutstandingOrderView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        OutstandingOrderView.this.txtSubCode.setVisible(Resources.isMemberTerminal());
                        OutstandingOrderView.this.lblSubCode.setVisible(Resources.isMemberTerminal());
                        if (Resources.exchangeNames != null) {
                            OutstandingOrderView.this.cmbExchange.removeAll();
                            OutstandingOrderView.this.cmbExchange.add("All");
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                OutstandingOrderView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            OutstandingOrderView.this.cmbExchange.select(0);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

