/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class NetShareCustodyView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.NetShareCustodyView";
    private Text txtAsOnDate;
    private Text txtSymbol;
    private Label lblAsOnDate;
    private Label lblSymbol;

    @Override
    public void createPartControl(Composite netCustody) {
        this.parent = netCustody;
        GridLayout gridContents = new GridLayout(8, false);
        netCustody.setLayout((Layout)gridContents);
        super.createPartControl(netCustody);
        this.lblSymbol = new Label(netCustody, 0);
        this.lblSymbol.setText("Symbol:");
        this.lblSymbol.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtSymbol = new Text(netCustody, 2048);
        this.txtSymbol.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addKeyListener(this.enterKeylistener);
        this.lblAsOnDate = new Label(netCustody, 0);
        this.lblAsOnDate.setText("As on Date:");
        this.lblAsOnDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtAsOnDate = new Text(netCustody, 2048);
        this.txtAsOnDate.setText(Utility.getCurrentDate());
        this.txtAsOnDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtAsOnDate.addKeyListener(this.enterKeylistener);
        if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            this.txtAsOnDate.setEnabled(false);
        } else {
            this.txtAsOnDate.setEnabled(true);
        }
        this.btnFetch = new Button(netCustody, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetShareCustodyView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(netCustody, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetShareCustodyView.this.editor.setText(NetShareCustodyView.this.browser.getText());
                NetShareCustodyView.this.rp.print(NetShareCustodyView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 8;
        databrows.widthHint = 500;
        this.browser = new Browser(netCustody, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
    }

    @Override
    public void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            Date fDate = Utility.getDate((String)this.txtAsOnDate.getText());
            String symbol = this.txtSymbol.getText().trim();
            if (fDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid from date");
            } else {
                ReportRequest rt = new ReportRequest(5, clientCode, fDate, fDate, symbol, null);
                super.sendReportRequest(clientCode, rt, false);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 5) {
                        NetShareCustodyView.this.recieveReportResponse(rsp);
                        NetShareCustodyView.this.logger.info((Object)"response recieved ReportResponse.NET_SHARE_CUSTODY");
                    }
                    if (o instanceof LoginConfirmation) {
                        NetShareCustodyView.this.txtClientCode.setText(Resources.clientId);
                        NetShareCustodyView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

