/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class CustomerPaymentView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.CustomerPaymentView";
    private Text txtFromDate;
    private Label lblFromDate;

    @Override
    public void createPartControl(Composite clientPayment) {
        this.parent = clientPayment;
        GridLayout gridContents = new GridLayout(6, false);
        clientPayment.setLayout((Layout)gridContents);
        super.createPartControl(clientPayment);
        this.lblFromDate = new Label(clientPayment, 0);
        this.lblFromDate.setText("From Date:");
        this.lblFromDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtFromDate = new Text(clientPayment, 2048);
        this.txtFromDate.setText(Utility.getCurrentDate());
        this.txtFromDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtFromDate.addKeyListener(this.enterKeylistener);
        this.btnFetch = new Button(clientPayment, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomerPaymentView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(clientPayment, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomerPaymentView.this.editor.setText(CustomerPaymentView.this.browser.getText());
                CustomerPaymentView.this.rp.print(CustomerPaymentView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 6;
        databrows.widthHint = 500;
        this.browser = new Browser(clientPayment, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
    }

    @Override
    public void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            Date fDate = Utility.getDate((String)this.txtFromDate.getText());
            if (clientCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Please enter client code");
            } else if (fDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid from date");
            } else {
                ReportRequest rt = new ReportRequest(8, clientCode, fDate, new Date());
                super.sendReportRequest(clientCode, rt, true);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 8) {
                        CustomerPaymentView.this.recieveReportResponse(rsp);
                        CustomerPaymentView.this.logger.info((Object)"response recieved ReportResponse.PAYMENT_REQUEST recieved");
                    }
                    if (o instanceof LoginConfirmation) {
                        CustomerPaymentView.this.txtClientCode.setText(Resources.clientId);
                        CustomerPaymentView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

