/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class ClientPortfolioView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.ClientPortfolioView";
    private static final int VIEW_WIDTH = 800;

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite content = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(7).equalWidth(false).applyTo(content);
        GridDataFactory.fillDefaults().grab(false, true).hint(800, -1).applyTo((Control)content);
        super.createPartControl(content);
        this.btnFetch = new Button(content, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientPortfolioView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(content, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientPortfolioView.this.editor.setText(ClientPortfolioView.this.browser.getText());
                ClientPortfolioView.this.rp.print(ClientPortfolioView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 4;
        databrows.widthHint = 800;
        this.browser = new Browser(content, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
        sc.setContent((Control)content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(content.computeSize(-1, -1));
    }

    @Override
    public void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            if (clientCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Please enter client code");
            } else {
                ReportRequest rt = new ReportRequest(9, clientCode);
                super.sendReportRequest(clientCode, rt, true);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 9) {
                        ClientPortfolioView.this.recieveReportResponse(rsp);
                        ClientPortfolioView.this.logger.info((Object)"CLIENT_MARGIN_REQUEST recieved");
                    }
                    if (o instanceof LoginConfirmation) {
                        ClientPortfolioView.this.txtClientCode.setText(Resources.clientId);
                        ClientPortfolioView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

