/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.BranchData;
import pk.com.softech.messages.BranchResponse;
import pk.com.softech.messages.ClientGroupData;
import pk.com.softech.messages.ClientGroupResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class ClientFloorView
extends BaseReport
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.ClientFloorView";
    private Combo cmbExchange;
    private Combo cmbBranch;
    private Combo cmbClientGroup;
    private Text txtTraderCode;
    private Text txtClientCode;

    @Override
    public void createPartControl(Composite netCustody) {
        this.parent = netCustody;
        GridLayout gridContents = new GridLayout(6, false);
        netCustody.setLayout((Layout)gridContents);
        Label lbl = new Label(this.parent, 0);
        lbl.setText("Exchange");
        this.cmbExchange = new Combo(this.parent, 8);
        this.setComboExchangeData();
        lbl = new Label(this.parent, 0);
        lbl.setText("Branch");
        this.cmbBranch = new Combo(this.parent, 8);
        this.setComboBranchData();
        lbl = new Label(this.parent, 0);
        lbl.setText("Client Group");
        this.cmbClientGroup = new Combo(this.parent, 8);
        this.setComboClientGroupData();
        lbl = new Label(this.parent, 0);
        lbl.setText("Trader Code");
        this.txtTraderCode = new Text(this.parent, 2048);
        this.txtTraderCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        lbl = new Label(this.parent, 0);
        lbl.setText("Client Code");
        this.txtClientCode = new Text(this.parent, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.btnFetch = new Button(this.parent, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientFloorView.this.sendReportRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnPrint = new Button(netCustody, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientFloorView.this.editor.setText(ClientFloorView.this.browser.getText());
                ClientFloorView.this.rp.print(ClientFloorView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 6;
        databrows.widthHint = 500;
        this.browser = new Browser(netCustody, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
    }

    private void setComboExchangeData() {
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                this.cmbExchange.setData((String)Resources.exchangeNames.get(i), Resources.exchangeCodes.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
    }

    @Override
    public void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            ReportRequest floorReq = new ReportRequest(14, clientCode);
            BranchData branchData = (BranchData)this.cmbBranch.getData(this.cmbBranch.getText());
            if (this.cmbBranch.getText().equals("All")) {
                floorReq.setBranchCode("All");
            } else {
                floorReq.setBranchCode(branchData.getCode());
            }
            ClientGroupData grpData = (ClientGroupData)this.cmbClientGroup.getData(this.cmbClientGroup.getText());
            if (this.cmbClientGroup.getText().equals("All")) {
                floorReq.setClientGroup("All");
            } else {
                floorReq.setClientGroup(grpData.getCode());
            }
            floorReq.setStExCode((String)this.cmbExchange.getData(this.cmbExchange.getText()));
            floorReq.setTraderCode(this.txtTraderCode.getText());
            super.sendReportRequest(clientCode, floorReq, false);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 14) {
                        ClientFloorView.this.recieveReportResponse(rsp);
                        ClientFloorView.this.logger.info((Object)"response recieved ReportResponse.CLIENT_FLOORS");
                    }
                    if (o instanceof LoginConfirmation) {
                        ClientFloorView.this.setComboExchangeData();
                    } else if (o instanceof BranchResponse) {
                        ClientFloorView.this.setComboBranchData();
                    } else if (o instanceof ClientGroupResponse) {
                        ClientFloorView.this.setComboClientGroupData();
                    }
                }
            });
        }
    }

    protected void setComboClientGroupData() {
        if (Resources.clientGroups != null) {
            this.cmbClientGroup.removeAll();
            this.cmbClientGroup.add("All");
            int i = 0;
            while (i < Resources.clientGroups.size()) {
                ClientGroupData data = (ClientGroupData)Resources.clientGroups.get(i);
                this.cmbClientGroup.setData(data.getName(), (Object)data);
                this.cmbClientGroup.add(data.getName());
                ++i;
            }
            this.cmbClientGroup.select(0);
        }
    }

    private void setComboBranchData() {
        if (Resources.branchData != null) {
            this.cmbBranch.removeAll();
            this.cmbBranch.add("All");
            int i = 0;
            while (i < Resources.branchData.size()) {
                BranchData data = (BranchData)Resources.branchData.get(i);
                this.cmbBranch.setData(data.getName(), (Object)data);
                this.cmbBranch.add(data.getName());
                ++i;
            }
            this.cmbBranch.select(0);
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

