/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class CgtHistoryView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.CgtHistoryView";
    private static final DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    public Date toDate;
    public Date fromDate;
    private Text txtTo;
    private Text txtFrom;
    private Button setFromDate;
    private Button setToDate;
    private boolean listenereIntialized = false;
    private FontMetrics fontMetrics = null;

    @Override
    public void createPartControl(Composite composite) {
        this.parent = composite;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridLayout gridContents = new GridLayout(8, false);
        composite.setLayout((Layout)gridContents);
        super.createPartControl(composite);
        GridData txtGridData = new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1);
        GridData btnGridData = new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1);
        this.txtFrom = this.createText(composite, 16384, txtGridData);
        this.txtFrom.setEnabled(false);
        this.setFromDate = new Button(composite, 8);
        this.setFromDate.setText("From Date");
        this.setFromDate.setLayoutData((Object)btnGridData);
        this.txtTo = this.createText(composite, 16384, txtGridData);
        this.txtTo.setEnabled(false);
        this.setToDate = new Button(composite, 8);
        this.setToDate.setText("To Date");
        this.setToDate.setLayoutData((Object)btnGridData);
        this.btnFetch = new Button(composite, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CgtHistoryView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)btnGridData);
        this.btnPrint = new Button(composite, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)btnGridData);
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CgtHistoryView.this.editor.setText(CgtHistoryView.this.browser.getText());
                CgtHistoryView.this.rp.print(CgtHistoryView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 8;
        databrows.widthHint = 500;
        this.browser = new Browser(composite, 0);
        this.browser.setLayoutData((Object)databrows);
        this.browser.setVisible(false);
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CgtHistoryView.this.listenereIntialized) {
                    CgtHistoryView.this.initializeListeners();
                    CgtHistoryView.this.listenereIntialized = true;
                }
            }
        });
    }

    @Override
    public void sendReportRequest() {
        String clientCode = this.txtClientCode.getText().trim();
        if (clientCode.equals("")) {
            MessageDialog.openError(null, (String)"Invalid information", (String)"Please enter client code");
            return;
        }
        if (this.fromDate == null) {
            this.btnFetch.setEnabled(true);
            MessageDialog.openInformation(null, (String)"Error", (String)"From date filter is not provided");
            return;
        }
        if (this.toDate == null) {
            this.btnFetch.setEnabled(true);
            MessageDialog.openInformation(null, (String)"Error", (String)"To date filter is not provided");
            return;
        }
        try {
            if (clientCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Please enter client code");
            } else {
                ReportRequest rt = null;
                rt = this.toDate != null && this.fromDate != null ? new ReportRequest(19, clientCode, this.fromDate, this.toDate) : new ReportRequest(19, clientCode);
                this.sendReportRequest(clientCode, rt, true);
            }
        }
        catch (Exception e) {
            this.btnFetch.setEnabled(true);
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportResponse rsp;
                    if (o instanceof ReportResponse && (rsp = (ReportResponse)o).getReportType() == 19) {
                        CgtHistoryView.this.recieveReportResponse(rsp);
                        CgtHistoryView.this.logger.info((Object)"ReportResponse.CASH_BOOK_DETAIL_WRT_TRADES recieved");
                    }
                    if (o instanceof LoginConfirmation) {
                        CgtHistoryView.this.txtClientCode.setText(Resources.clientId);
                        CgtHistoryView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    private Text createText(Composite parent, int allignment, GridData gridData) {
        Text temp = new Text(parent, 0xFFFFFFFF | allignment);
        temp.setLayoutData((Object)gridData);
        temp.setEnabled(true);
        return temp;
    }

    private void initializeListeners() {
        Calendar calendar = Calendar.getInstance();
        df.format(calendar.getTime());
        calendar.add(5, -Resources.maxReportDaysLimit);
        final int maxReports = Resources.maxReportDaysLimit >= 0 ? Resources.maxReportDaysLimit : 0;
        this.setFromDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(String.valueOf(calendar.getMonth() + 1)) + "/" + calendar.getDay() + "/" + calendar.getYear();
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(String.valueOf(calendar.getMonth() + 1)) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = CgtHistoryView.this.covertStringToDate(currentDate);
                        Date fDate = CgtHistoryView.this.covertStringToDate(dateString);
                        if (fDate.compareTo(cDate) < 1 && fDate.compareTo(cDate) != 0) {
                            CgtHistoryView.this.txtFrom.setText(dateString);
                            (this).CgtHistoryView.this.fromDate = fDate;
                            dialog.close();
                        } else {
                            (this).CgtHistoryView.this.fromDate = null;
                            MessageDialog.openError(null, (String)"Not Allowed", (String)"From date filter is not allowed to the current date");
                            CgtHistoryView.this.txtFrom.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.setToDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(String.valueOf(calendar.getMonth() + 1)) + "/" + calendar.getDay() + "/" + calendar.getYear();
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(String.valueOf(calendar.getMonth() + 1)) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = CgtHistoryView.this.covertStringToDate(currentDate);
                        Date tDate = CgtHistoryView.this.covertStringToDate(dateString);
                        if (tDate.compareTo(cDate) < 1 || tDate.compareTo(cDate) == 0) {
                            if ((this).CgtHistoryView.this.fromDate != null) {
                                long diffInMillies = Math.abs(tDate.getTime() - (this).CgtHistoryView.this.fromDate.getTime());
                                long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS) + 1L;
                                if (diff >= (long)maxReports) {
                                    CgtHistoryView.this.txtTo.setText(dateString);
                                    (this).CgtHistoryView.this.toDate = tDate;
                                    dialog.close();
                                } else if (diff <= (long)maxReports) {
                                    diff = (long)maxReports - diff;
                                    MessageDialog.openInformation(null, (String)"Not Allowed", (String)("Please Skip days : " + diff + "  in From Date filter or Increase Days in To Date Filter to place report request, Else See in the Report Section for this report range"));
                                    CgtHistoryView.this.txtTo.setText("");
                                    dialog.close();
                                    (this).CgtHistoryView.this.toDate = null;
                                }
                            } else {
                                MessageDialog.openInformation(null, (String)"Information", (String)"Please select from date filter first.");
                                CgtHistoryView.this.txtTo.setText("");
                                dialog.close();
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid date selection , To date filter less then the current date");
                            CgtHistoryView.this.txtTo.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
    }

    public Date covertStringToDate(String str) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = df.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

