/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JEditorPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.reports.ReportPlugin;
import pk.com.softech.tradingterminal.reports.utils.ReportPrinter;

abstract class BaseReport
extends ViewPart
implements ICollectionObserver,
Observer {
    protected SimpleDateFormat dateFormate = null;
    protected Composite parent;
    protected Label lblClientCode;
    protected Text txtClientCode;
    protected Browser browser;
    protected JEditorPane editor;
    protected Button btnPrint;
    protected Button btnFetch;
    protected ReportPrinter rp = null;
    protected Log logger = LogFactory.getLog(this.getClass());
    KeyListener enterKeylistener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r') {
                BaseReport.this.sendReportRequest();
            }
        }
    };
    IPreferenceStore prefrences;

    public BaseReport() {
        Resources.supportServerMessage.addObserver((Observer)this);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allReportList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().addCollectionObserver((ICollectionObserver)this);
        this.dateFormate = CorePlugin.getDateFormat();
        this.rp = new ReportPrinter();
        this.editor = new JEditorPane();
        this.editor.setContentType("text/html");
        this.editor.setEditable(false);
        this.editor.setVisible(false);
        this.prefrences = ReportPlugin.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.lblClientCode = new Label(parent, 0);
        this.lblClientCode.setText("Client Code:");
        this.lblClientCode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtClientCode = new Text(parent, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.setLayoutData((Object)new GridData(80, -1));
        this.txtClientCode.addKeyListener(this.enterKeylistener);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
    }

    public void setFocus() {
    }

    public void itemAdded(Object o) {
    }

    public void itemRemoved(Object o) {
    }

    public void recieveReportResponse(final ReportResponse resp) {
        this.browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BaseReport.this.browser.setVisible(true);
                BaseReport.this.btnFetch.setEnabled(true);
                if (resp.getHTML() == null) {
                    BaseReport.this.browser.setText("Report not available");
                } else {
                    int fontSize = 1;
                    try {
                        fontSize = BaseReport.this.prefrences.getInt("REPORTS_FONT");
                    }
                    catch (Exception exception) {}
                    String response = resp.getHTML();
                    if (response != null && fontSize != 1) {
                        response = response.replaceAll("font size=2", "font size=" + fontSize);
                    }
                    BaseReport.this.browser.setText(response);
                    BaseReport.this.browser.redraw();
                }
                BaseReport.this.btnPrint.setEnabled(true);
            }
        });
    }

    public void dispose() {
        CorePlugin.getRepository().allReportList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    BaseReport.this.txtClientCode.setText(Resources.clientId);
                    BaseReport.this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).BaseReport.this.browser.setText("");
                            (this).BaseReport.this.editor.setText("");
                        }
                    });
                }
            });
        }
    }

    protected void sendReportRequest(String clientCode, ReportRequest rt, boolean checkClientCode) {
        if (this.btnFetch.isEnabled() && Resources.isServerConnected((String)clientCode.trim(), (boolean)checkClientCode, (boolean)true) && Resources.getServerLink((String)clientCode.trim(), (boolean)checkClientCode, (boolean)true).writeData((Object)rt)) {
            this.btnFetch.setEnabled(false);
            this.logger.info((Object)("sending report request " + rt.getReportType()));
        }
    }

    abstract void sendReportRequest();
}

