/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.views;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.ReportRequest;
import pk.com.softech.messages.ReportResponse;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.reports.views.BaseReport;

public class AccountLedgerView
extends BaseReport {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.reports.views.AccountLedgerView";
    private Text txtFromDate;
    private Text txtToDate;
    private Label lblFromDate;
    private Label lblToDate;

    @Override
    public void createPartControl(Composite inputForm) {
        this.parent = inputForm;
        GridLayout gridContents = new GridLayout(10, false);
        inputForm.setLayout((Layout)gridContents);
        super.createPartControl(inputForm);
        this.lblFromDate = new Label(inputForm, 0);
        this.lblFromDate.setText("From Date:");
        this.lblFromDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtFromDate = new Text(inputForm, 2048);
        this.txtFromDate.setText(Utility.getCurrentDate());
        this.txtFromDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtFromDate.addKeyListener(this.enterKeylistener);
        this.lblToDate = new Label(inputForm, 0);
        this.lblToDate.setText("To Date:");
        this.lblToDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtToDate = new Text(inputForm, 2048);
        this.txtToDate.setText(Utility.getCurrentDate());
        this.txtToDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtToDate.addKeyListener(this.enterKeylistener);
        this.btnFetch = new Button(inputForm, 8);
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountLedgerView.this.sendReportRequest();
            }
        });
        this.btnFetch.setText("Fetch");
        this.btnFetch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint = new Button(inputForm, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.setEnabled(false);
        this.btnPrint.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountLedgerView.this.editor.setText(AccountLedgerView.this.browser.getText());
                AccountLedgerView.this.rp.print(AccountLedgerView.this.editor);
            }
        });
        GridData databrows = new GridData(1808);
        databrows.horizontalSpan = 8;
        databrows.widthHint = 500;
        this.browser = new Browser(inputForm, 0);
        this.browser.setVisible(false);
        this.browser.setLayoutData((Object)databrows);
    }

    @Override
    public void sendReportRequest() {
        try {
            String clientCode = this.txtClientCode.getText().trim();
            Date tDate = Utility.getDate((String)this.txtToDate.getText());
            Date fDate = Utility.getDate((String)this.txtFromDate.getText());
            if (clientCode.equals("")) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Please enter client code");
            } else if (fDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid from date");
            } else if (tDate == null) {
                MessageDialog.openError(null, (String)"Invalid information", (String)"Invalid to date");
            } else {
                ReportRequest rt = new ReportRequest(4, clientCode, fDate, tDate);
                super.sendReportRequest(clientCode, rt, true);
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid information", (String)("Missing some mandatory information" + e.getMessage()));
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ReportResponse) {
                        ReportResponse rsp = (ReportResponse)o;
                        if (rsp.getReportType() == 4) {
                            AccountLedgerView.this.recieveReportResponse(rsp);
                        }
                        AccountLedgerView.this.logger.info((Object)"report recieved ReportResponse.CLIENT_ACCOUNT_LEDGER");
                    }
                    if (o instanceof LoginConfirmation) {
                        AccountLedgerView.this.txtClientCode.setText(Resources.clientId);
                        AccountLedgerView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

