/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JEditorPane;
import javax.swing.text.View;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class ReportPrinter
implements Printable {
    protected int currentPage = -1;
    protected JEditorPane jeditorPane = null;
    protected double pageEndY = 0.0;
    protected double pageStartY = 0.0;
    protected boolean scaleWidthToFit = true;
    protected PageFormat pFormat = null;
    protected PrinterJob pJob = null;

    public ReportPrinter() {
        try {
            this.pFormat = new PageFormat();
            this.pFormat.setOrientation(0);
            Paper paper = new Paper();
            paper.setSize(612.0, 792.0);
            paper.setImageableArea(18.0, 18.0, 576.0, 756.0);
            this.pFormat.setPaper(paper);
            this.pJob = PrinterJob.getPrinterJob();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.jeditorPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.jeditorPane.validate();
        View rootView = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        if (this.scaleWidthToFit && this.jeditorPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            scale = pageFormat.getImageableWidth() / this.jeditorPane.getMinimumSize().getWidth();
            graphics2D.scale(scale, scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.pageStartY), (int)this.jeditorPane.getMinimumSize().getWidth(), (int)this.jeditorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    protected boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            int i = 0;
            while (i < view.getViewCount()) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation != null && this.printView(graphics2D, childAllocation, childView = view.getView(i))) {
                    pageExists = true;
                }
                ++i;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    public void print(JEditorPane jedPane) {
        this.setDocument(jedPane);
        this.printDialog();
    }

    protected void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                CorePlugin.logException((Exception)printerException);
            }
        }
    }

    private void setDocument(JEditorPane jedPane) {
        try {
            this.jeditorPane = new JEditorPane();
            this.jeditorPane.setContentType(jedPane.getContentType());
            String text = jedPane.getText();
            text = text.replaceAll("size=\"2\"", "size=\"1\"");
            this.jeditorPane.setText(text);
        }
        catch (Exception e) {
            CorePlugin.logException((Exception)e);
        }
    }

    public boolean getScaleWidthToFit() {
        return this.scaleWidthToFit;
    }

    public void setScaleWidthToFit(boolean scaleWidth) {
        this.scaleWidthToFit = scaleWidth;
    }
}

