/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.reports.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.reports.ReportPlugin;

public class ReportsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button smallFont;
    private Button normalFont;
    private Button largeFont;
    IPreferenceStore pref;

    public void init(IWorkbench workbench) {
        this.pref = ReportPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Group group = new Group(content, 0);
        group.setText("Report Font Size");
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        group.setLayout((Layout)gridLayout);
        this.smallFont = new Button((Composite)group, 16);
        this.smallFont.setText("Small");
        this.smallFont.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.normalFont = new Button((Composite)group, 16);
        this.normalFont.setText("Normal");
        this.normalFont.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.largeFont = new Button((Composite)group, 16);
        this.largeFont.setText("Large");
        this.largeFont.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        this.smallFont.setSelection(this.pref.getInt("REPORTS_FONT") == 0);
        this.normalFont.setSelection(this.pref.getInt("REPORTS_FONT") == 1);
        this.largeFont.setSelection(this.pref.getInt("REPORTS_FONT") == 3);
        super.performDefaults();
    }

    public boolean performOk() {
        int fontSize = 1;
        if (this.smallFont.getSelection()) {
            fontSize = 0;
        } else if (this.largeFont.getSelection()) {
            fontSize = 3;
        }
        this.pref.setValue("REPORTS_FONT", fontSize);
        return super.performOk();
    }
}

