/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Timestamp;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.util.Date;
import sun.security.util.CurveDB;
import sun.security.util.NamedCurve;

public class ConstraintsParameters {
    private final String algorithm;
    private final AlgorithmParameters algParams;
    private final Key key;
    private final X509Certificate cert;
    private final boolean trustedMatch;
    private final Date pkixDate;
    private final Timestamp jarTimestamp;
    private final String variant;
    private final String[] curveStr;
    private static final String[] EMPTYLIST = new String[0];

    public ConstraintsParameters(X509Certificate x509Certificate, boolean bl, Date date, Timestamp timestamp, String string) {
        this.cert = x509Certificate;
        this.trustedMatch = bl;
        this.pkixDate = date;
        this.jarTimestamp = timestamp;
        this.variant = string == null ? "generic" : string;
        this.algorithm = null;
        this.algParams = null;
        this.key = null;
        this.curveStr = x509Certificate != null ? ConstraintsParameters.getNamedCurveFromKey(x509Certificate.getPublicKey()) : EMPTYLIST;
    }

    public ConstraintsParameters(String string, AlgorithmParameters algorithmParameters, Key key, String string2) {
        this.algorithm = string;
        this.algParams = algorithmParameters;
        this.key = key;
        this.curveStr = ConstraintsParameters.getNamedCurveFromKey(key);
        this.cert = null;
        this.trustedMatch = false;
        this.pkixDate = null;
        this.jarTimestamp = null;
        this.variant = string2 == null ? "generic" : string2;
    }

    public ConstraintsParameters(X509Certificate x509Certificate) {
        this(x509Certificate, false, null, null, "generic");
    }

    public ConstraintsParameters(Timestamp timestamp) {
        this(null, false, null, timestamp, "generic");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameters getAlgParams() {
        return this.algParams;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isTrustedMatch() {
        return this.trustedMatch;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Date getPKIXParamDate() {
        return this.pkixDate;
    }

    public Timestamp getJARTimestamp() {
        return this.jarTimestamp;
    }

    public String getVariant() {
        return this.variant;
    }

    public String[] getNamedCurve() {
        return this.curveStr;
    }

    public static String[] getNamedCurveFromKey(Key key) {
        if (key instanceof ECKey) {
            NamedCurve namedCurve = CurveDB.lookup(((ECKey)((Object)key)).getParams());
            return namedCurve == null ? EMPTYLIST : CurveDB.getNamesByOID(namedCurve.getObjectId());
        }
        return EMPTYLIST;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cert:       ");
        if (this.cert != null) {
            stringBuilder.append(this.cert.toString());
            stringBuilder.append("\nSigAlgo:    ");
            stringBuilder.append(this.cert.getSigAlgName());
        } else {
            stringBuilder.append("None");
        }
        stringBuilder.append("\nAlgParams:  ");
        if (this.getAlgParams() != null) {
            this.getAlgParams().toString();
        } else {
            stringBuilder.append("None");
        }
        stringBuilder.append("\nNamedCurves: ");
        for (String string : this.getNamedCurve()) {
            stringBuilder.append(string + " ");
        }
        stringBuilder.append("\nVariant:    " + this.getVariant());
        return stringBuilder.toString();
    }
}

