/*
 * Decompiled with CFR 0.152.
 */
package notification.internal;

import java.util.ArrayList;
import java.util.List;
import notification.INotification;
import notification.internal.CommonFonts;
import notification.internal.CommonImages;
import notification.internal.NotificationPopupColors;
import notification.internal.SwtUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NotificationPopup
extends Window {
    private static final int TITLE_HEIGHT = 24;
    private static final String LABEL_NOTIFICATION = "Notification";
    private static final String LABEL_JOB_CLOSE = "Close Notification Job";
    private static final int MAX_WIDTH = 400;
    private static final int MIN_HEIGHT = 100;
    private static final long DEFAULT_DELAY_CLOSE = 8000L;
    private static final int PADDING_EDGE = 5;
    private long delayClose = 8000L;
    private static final String NOTIFICATIONS_HIDDEN = "more...";
    private static final int NUM_NOTIFICATIONS_TO_DISPLAY = 4;
    protected LocalResourceManager resources;
    private NotificationPopupColors color;
    private final Display display;
    private Shell shell;
    private Region lastUsedRegion;
    private Image lastUsedBgImage;
    private List<INotification> notifications;
    private final Job closeJob = new Job("Close Notification Job"){

        protected IStatus run(IProgressMonitor monitor) {
            if (!NotificationPopup.this.display.isDisposed()) {
                NotificationPopup.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = NotificationPopup.this.getShell();
                        if (shell == null || shell.isDisposed()) {
                            return;
                        }
                        if (NotificationPopup.this.isMouseOver(shell)) {
                            NotificationPopup.this.scheduleAutoClose();
                            return;
                        }
                        if (!NotificationPopup.this.isCloseable()) {
                            NotificationPopup.this.scheduleAutoClose();
                            return;
                        }
                        NotificationPopup.this.closeFade();
                    }
                });
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private final boolean respectDisplayBounds = true;
    private final boolean respectMonitorBounds = true;
    private SwtUtil.FadeJob fadeJob;
    private boolean supportsFading;
    private boolean fadingEnabled;
    private boolean closeable;

    public NotificationPopup(Display display) {
        this(display, 540680);
    }

    public NotificationPopup(Display display, int style) {
        super(new Shell(display));
        this.setShellStyle(style);
        this.display = display;
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        this.initResources();
        this.closeJob.setSystem(true);
    }

    public boolean isFadingEnabled() {
        return this.fadingEnabled;
    }

    public void setFadingEnabled(boolean fadingEnabled) {
        this.fadingEnabled = fadingEnabled;
    }

    protected String getPopupShellTitle() {
        return LABEL_NOTIFICATION;
    }

    protected Image getPopupShellImage(int maximumHeight) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0 && (workbenchWindow = windows[0]) != null && !workbenchWindow.getShell().isDisposed()) {
            Image image = this.getShell().getImage();
            int diff = Integer.MAX_VALUE;
            if (image != null && image.getBounds().height <= maximumHeight) {
                diff = maximumHeight - image.getBounds().height;
            } else {
                image = null;
            }
            Image[] images = this.getShell().getImages();
            if (images != null && images.length > 0) {
                Image[] imageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image2 = imageArray[n2];
                    int newDiff = maximumHeight - image2.getBounds().height;
                    if (newDiff >= 0 && newDiff <= diff) {
                        diff = newDiff;
                        image = image2;
                    }
                    ++n2;
                }
            }
            return image;
        }
        return null;
    }

    protected void createContentArea(Composite parent) {
        int count = 0;
        int i = this.notifications.size() - 1;
        while (i > -1) {
            INotification notification = this.notifications.get(i);
            Composite notificationComposite = new Composite(parent, 524288);
            GridLayout layout = new GridLayout(2, false);
            notificationComposite.setLayout((Layout)layout);
            notificationComposite.setBackground(parent.getBackground());
            if (count < 4) {
                Label notificationLabelIcon = new Label(notificationComposite, 524288);
                notificationLabelIcon.setBackground(parent.getBackground());
                notificationLabelIcon.setImage(notification.getNotificationImage());
                Link itemLink = new Link(notificationComposite, 524289);
                itemLink.setText(notification.getLabel());
                itemLink.setFont(CommonFonts.BOLD);
                itemLink.setBackground(parent.getBackground());
                itemLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                String descriptionText = null;
                if (notification.getDescription() != null) {
                    descriptionText = notification.getDescription();
                }
                if (descriptionText != null && !descriptionText.trim().equals("")) {
                    Label descriptionLabel = new Label(notificationComposite, 524352);
                    descriptionLabel.setText(descriptionText);
                    descriptionLabel.setBackground(parent.getBackground());
                    descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                    ((GridData)descriptionLabel.getLayoutData()).widthHint = 400;
                }
            } else {
                int numNotificationsRemain = this.notifications.size() - count;
                Link remainingHyperlink = new Link(notificationComposite, 524288);
                remainingHyperlink.setBackground(parent.getBackground());
                remainingHyperlink.setText(String.valueOf(numNotificationsRemain) + " " + NOTIFICATIONS_HIDDEN);
                GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)remainingHyperlink);
                break;
            }
            ++count;
            --i;
        }
    }

    protected void createTitleArea(Composite parent) {
        ((GridData)parent.getLayoutData()).heightHint = 24;
        Label titleImageLabel = new Label(parent, 2048);
        titleImageLabel.setImage(this.getPopupShellImage(24));
        Label titleTextLabel = new Label(parent, 0);
        titleTextLabel.setText(this.getPopupShellTitle());
        titleTextLabel.setFont(CommonFonts.BOLD);
        titleTextLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        titleTextLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        final Label button = new Label(parent, 0);
        button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE_HOVER));
            }

            public void mouseExit(MouseEvent e) {
                button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
            }
        });
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.close();
                NotificationPopup.this.setReturnCode(1);
            }
        });
    }

    private void initResources() {
        this.color = new NotificationPopupColors(this.display, (ResourceManager)this.resources);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setBackground(this.color.getBorder());
    }

    public void create() {
        super.create();
        this.addRegion(this.shell);
    }

    private void addRegion(Shell shell) {
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.lastUsedRegion = region;
    }

    private boolean isMouseOver(Shell shell) {
        if (this.display.isDisposed()) {
            return false;
        }
        return shell.getBounds().contains(this.display.getCursorLocation());
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        this.shell.setLocation(this.fixupDisplayBounds(this.shell.getSize(), this.shell.getLocation()));
        this.supportsFading = this.isFadingEnabled() ? SwtUtil.setAlpha(this.shell, 0) : false;
        this.shell.layout();
        this.shell.setVisible(true);
        if (this.supportsFading) {
            this.fadeJob = SwtUtil.fadeIn(this.shell, new SwtUtil.IFadeListener(){

                @Override
                public void faded(Shell shell, int alpha) {
                    if (shell.isDisposed()) {
                        return;
                    }
                    if (alpha == 255) {
                        NotificationPopup.this.scheduleAutoClose();
                    }
                }
            });
        } else {
            this.scheduleAutoClose();
        }
        return 0;
    }

    protected void scheduleAutoClose() {
        if (this.delayClose > 0L) {
            this.closeJob.schedule(this.delayClose);
        }
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        outerCircle.setLayout((Layout)layout);
        final Composite titleCircle = new Composite(outerCircle, 524288);
        titleCircle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        titleCircle.setBackgroundMode(2);
        layout = new GridLayout(4, false);
        layout.marginWidth = 3;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 3;
        titleCircle.setLayout((Layout)layout);
        titleCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = titleCircle.getClientArea();
                NotificationPopup.this.lastUsedBgImage = new Image((Device)titleCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)NotificationPopup.this.lastUsedBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                Image oldBGImage = titleCircle.getBackgroundImage();
                titleCircle.setBackgroundImage(NotificationPopup.this.lastUsedBgImage);
                if (oldBGImage != null) {
                    oldBGImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(NotificationPopup.this.color.getGradientBegin());
                gc.setBackground(NotificationPopup.this.color.getGradientEnd());
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(NotificationPopup.this.color.getBorder());
                gc.drawPoint(2, 0);
                gc.drawPoint(3, 0);
                gc.drawPoint(1, 1);
                gc.drawPoint(0, 2);
                gc.drawPoint(0, 3);
                gc.drawPoint(clArea.width - 4, 0);
                gc.drawPoint(clArea.width - 3, 0);
                gc.drawPoint(clArea.width - 2, 1);
                gc.drawPoint(clArea.width - 1, 2);
                gc.drawPoint(clArea.width - 1, 3);
            }
        });
        this.createTitleArea(titleCircle);
        Composite outerContentCircle = new Composite(outerCircle, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerContentCircle.setBackground(outerCircle.getBackground());
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.color.getBorder());
        Composite innerContentCircle = new Composite(middleContentCircle, 524288);
        innerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        innerContentCircle.setLayout((Layout)layout);
        ((GridLayout)innerContentCircle.getLayout()).marginLeft = 5;
        ((GridLayout)innerContentCircle.getLayout()).marginRight = 2;
        innerContentCircle.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.createContentArea(innerContentCircle);
        return outerCircle;
    }

    protected void initializeBounds() {
        Rectangle clArea = this.getPrimaryClientArea();
        Point initialSize = this.shell.computeSize(-1, -1);
        int height = Math.max(initialSize.y, 100);
        int width = Math.min(initialSize.x, 400);
        Point size = new Point(width, height);
        this.shell.setLocation(clArea.width + clArea.x - size.x - 5, clArea.height + clArea.y - size.y - 5);
        this.shell.setSize(size);
    }

    private Rectangle getPrimaryClientArea() {
        Monitor primaryMonitor = this.shell.getDisplay().getPrimaryMonitor();
        return primaryMonitor != null ? primaryMonitor.getClientArea() : this.shell.getDisplay().getClientArea();
    }

    public void closeFade() {
        if (this.fadeJob != null) {
            this.fadeJob.cancelAndWait(false);
        }
        if (this.supportsFading) {
            this.fadeJob = SwtUtil.fadeOut(this.getShell(), new SwtUtil.IFadeListener(){

                @Override
                public void faded(Shell shell, int alpha) {
                    if (!shell.isDisposed()) {
                        if (alpha == 0) {
                            shell.close();
                        } else if (NotificationPopup.this.isMouseOver(shell)) {
                            if (NotificationPopup.this.fadeJob != null) {
                                NotificationPopup.this.fadeJob.cancelAndWait(false);
                            }
                            NotificationPopup.this.fadeJob = SwtUtil.fastFadeIn(shell, new SwtUtil.IFadeListener(){

                                @Override
                                public void faded(Shell shell, int alpha) {
                                    if (shell.isDisposed()) {
                                        return;
                                    }
                                    if (alpha == 255) {
                                        NotificationPopup.this.scheduleAutoClose();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        } else {
            this.shell.close();
        }
    }

    public boolean close() {
        this.resources.dispose();
        if (this.lastUsedRegion != null) {
            this.lastUsedRegion.dispose();
        }
        if (this.lastUsedBgImage != null && !this.lastUsedBgImage.isDisposed()) {
            this.lastUsedBgImage.dispose();
        }
        return super.close();
    }

    public long getDelayClose() {
        return this.delayClose;
    }

    public void setDelayClose(long delayClose) {
        this.delayClose = delayClose;
    }

    private Point fixupDisplayBounds(Point tipSize, Point location) {
        Point rightBounds = new Point(tipSize.x + location.x, tipSize.y + location.y);
        Rectangle bounds = this.shell.getDisplay().getPrimaryMonitor().getBounds();
        if (!bounds.contains(location) || !bounds.contains(rightBounds)) {
            if (rightBounds.x > bounds.x + bounds.width) {
                location.x -= rightBounds.x - (bounds.x + bounds.width);
            }
            if (rightBounds.y > bounds.y + bounds.height) {
                location.y -= rightBounds.y - (bounds.y + bounds.height);
            }
            if (location.x < bounds.x) {
                location.x = bounds.x;
            }
            if (location.y < bounds.y) {
                location.y = bounds.y;
            }
        }
        return location;
    }

    public void setContents(List<INotification> notifications) {
        this.notifications = new ArrayList<INotification>(notifications);
    }

    public List<INotification> getNotifications() {
        return new ArrayList<INotification>(this.notifications);
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }
}

