/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.meta;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.RetCode;
import com.tictactec.ta.lib.meta.TaFuncSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TaFuncMetaInfo
extends TaFuncSignature {
    Method method;
    Method lookbackMethod;
    Class[] outVarTypes;
    Class[] optionTypes;
    Class[] parameterTypes;
    static final int TOTAL_FIX_PARAMETERS = 4;
    static final int INPUT_FIX_PARAMETERS = 2;
    static final int OUTPUT_FIX_PARAMETERS = 2;

    public TaFuncMetaInfo(String name, Method method, Method lookbackMethod) {
        this.name = name;
        this.method = method;
        this.lookbackMethod = lookbackMethod;
        this.optionTypes = lookbackMethod.getParameterTypes();
        this.parameterTypes = method.getParameterTypes();
        int ins = this.getNumberOfInputParameters();
        int outs = this.getNumberOfOutputParameters();
        this.createVarTypes(ins, outs);
    }

    int getNumberOfInputParameters() {
        return this.getFirstMInteger() - this.optionTypes.length - 2;
    }

    int getNumberOfOutputParameters() {
        return this.parameterTypes.length - this.getFirstMInteger() - 2;
    }

    int getFirstMInteger() {
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (this.parameterTypes[i].equals(MInteger.class)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void createVarTypes(int ins, int outs) {
        assert (ins > 0 && outs > 0);
        this.inVarTypes = new Class[ins];
        this.outVarTypes = new Class[outs];
        int i = 0;
        while (i < ins) {
            this.inVarTypes[i] = this.parameterTypes[2 + i];
            ++i;
        }
        int offset = 2 + ins + this.optionTypes.length + 2;
        int i2 = 0;
        while (i2 < outs) {
            this.outVarTypes[i2] = this.parameterTypes[offset + i2];
            ++i2;
        }
    }

    @Override
    public Class[] getInVarTypes() {
        return this.inVarTypes;
    }

    public Method getLookbackMethod() {
        return this.lookbackMethod;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class[] getOptionTypes() {
        return this.optionTypes;
    }

    public Class[] getOutVarTypes() {
        return this.outVarTypes;
    }

    public boolean is11() {
        return this.inVarTypes.length == 1 && this.outVarTypes.length == 1;
    }

    public boolean is1N() {
        return this.inVarTypes.length == 1 && this.outVarTypes.length > 1;
    }

    public boolean isN1() {
        return this.inVarTypes.length > 1 && this.outVarTypes.length == 1;
    }

    public boolean isNN() {
        return this.inVarTypes.length > 1 && this.outVarTypes.length > 1;
    }

    public RetCode call(Core taCore, Object[] inArs, int startIndex, int endIndex, Object[] outArs, MInteger outBegIdx, MInteger outNbElement, Object ... options) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] parameters = new Object[inArs.length + outArs.length + options.length + 4];
        parameters[0] = startIndex;
        parameters[1] = endIndex;
        int i = 2;
        int j = 0;
        while (j < this.inVarTypes.length) {
            parameters[i++] = inArs[j];
            ++j;
        }
        Object[] objectArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Object opt = objectArray[n2];
            parameters[i++] = opt;
            ++n2;
        }
        parameters[i++] = outBegIdx;
        parameters[i++] = outNbElement;
        j = 0;
        while (j < this.outVarTypes.length) {
            parameters[i++] = outArs[j];
            ++j;
        }
        return (RetCode)((Object)this.getMethod().invoke((Object)taCore, parameters));
    }

    public int callLookback(Core taCore, Object ... options) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        System.out.println(this.getLookbackMethod());
        return (Integer)this.getLookbackMethod().invoke((Object)taCore, options);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + "[");
        sb.append(this.inVarTypes.length);
        sb.append(":");
        sb.append(this.outVarTypes.length);
        sb.append("]");
        sb.append("IN:(");
        int i = 0;
        while (i < this.inVarTypes.length) {
            sb.append(this.inVarTypes[i].getName());
            if (i < this.inVarTypes.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(") OUT(");
        i = 0;
        while (i < this.outVarTypes.length) {
            sb.append(this.outVarTypes[i].getName());
            if (i < this.outVarTypes.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

