/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.meta;

import com.tictactec.ta.lib.CoreAnnotated;
import com.tictactec.ta.lib.MAType;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.RetCode;
import com.tictactec.ta.lib.meta.PriceInputParameter;
import com.tictactec.ta.lib.meta.TaFuncService;
import com.tictactec.ta.lib.meta.TaGrpService;
import com.tictactec.ta.lib.meta.annotation.FuncInfo;
import com.tictactec.ta.lib.meta.annotation.InputParameterInfo;
import com.tictactec.ta.lib.meta.annotation.InputParameterType;
import com.tictactec.ta.lib.meta.annotation.IntegerList;
import com.tictactec.ta.lib.meta.annotation.IntegerRange;
import com.tictactec.ta.lib.meta.annotation.OptInputParameterInfo;
import com.tictactec.ta.lib.meta.annotation.OptInputParameterType;
import com.tictactec.ta.lib.meta.annotation.OutputParameterInfo;
import com.tictactec.ta.lib.meta.annotation.OutputParameterType;
import com.tictactec.ta.lib.meta.annotation.RealList;
import com.tictactec.ta.lib.meta.annotation.RealRange;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CoreMetaData
implements Comparable<CoreMetaData> {
    private static final transient String CONTACT_DEVELOPERS = "Contact developers";
    private static final transient String INDEX_OUT_OF_BOUNDS = "Index out of bounds";
    private static final transient String ILLEGAL_NUMBER_OF_ARGUMENTS = "Illegal number of arguments";
    private static final transient String ARRAY_IS_NULL = "Array is null";
    private static final transient String INT_ARRAY_EXPECTED = "int[] expected";
    private static final transient String DOUBLE_ARRAY_EXPECTED = "double[] expected";
    private static final transient String PRICE_EXPECTED = "PriceInputParameter object expected";
    private static final transient Class<CoreAnnotated> coreClass = CoreAnnotated.class;
    private static final transient String LOOKBACK_SUFFIX = "Lookback";
    private static transient CoreAnnotated taCore = null;
    private String name = null;
    private Method function = null;
    private Method lookback = null;
    private static transient Map<String, CoreMetaData> taFuncMap = null;
    private static transient Map<String, Set<CoreMetaData>> taGrpMap = null;
    private transient Object[] callInputParams = null;
    private transient Object[] callOutputParams = null;
    private transient Object[] callOptInputParams = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreMetaData() {
        Class<CoreAnnotated> clazz = coreClass;
        synchronized (clazz) {
            if (taCore == null) {
                taCore = new CoreAnnotated();
            }
        }
    }

    @Override
    public int compareTo(CoreMetaData arg) {
        return this.name.compareTo(arg.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, CoreMetaData> getAllFuncs() {
        Class<CoreAnnotated> clazz = coreClass;
        synchronized (clazz) {
            if (taFuncMap == null) {
                taFuncMap = CoreMetaData.getTaFuncMetaInfoMap();
            }
        }
        return taFuncMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Set<CoreMetaData>> getAllGrps() {
        Class<CoreAnnotated> clazz = coreClass;
        synchronized (clazz) {
            if (taGrpMap == null) {
                taGrpMap = CoreMetaData.getTaGrpMetaInfoMap();
            }
        }
        return taGrpMap;
    }

    private static Map<String, Method> getLookbackMethodMap() {
        Method[] ms;
        HashMap<String, Method> map = new HashMap<String, Method>();
        Method[] methodArray = ms = coreClass.getDeclaredMethods();
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().endsWith(LOOKBACK_SUFFIX)) {
                map.put(m.getName(), m);
            }
            ++n2;
        }
        return map;
    }

    private static Map<String, CoreMetaData> getTaFuncMetaInfoMap() {
        TreeMap<String, CoreMetaData> result = new TreeMap<String, CoreMetaData>();
        Method[] ms = coreClass.getDeclaredMethods();
        Map<String, Method> lookbackMap = CoreMetaData.getLookbackMethodMap();
        Method[] methodArray = ms;
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            String lookbackName;
            Method lookbackMethod;
            Method funcMethod = methodArray[n2];
            String fn = funcMethod.getName();
            if (funcMethod.getReturnType().equals(RetCode.class) && (lookbackMethod = lookbackMap.get(lookbackName = String.valueOf(fn) + LOOKBACK_SUFFIX)) != null) {
                FuncInfo info = CoreMetaData.getFuncInfo(funcMethod);
                String funcName = info.name();
                CoreMetaData mi = new CoreMetaData();
                mi.name = funcName;
                mi.function = funcMethod;
                mi.lookback = lookbackMethod;
                result.put(funcName, mi);
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Set<CoreMetaData>> getTaGrpMetaInfoMap() {
        if (taFuncMap == null) {
            CoreMetaData.getAllFuncs();
        }
        TreeMap<String, Set<CoreMetaData>> result = new TreeMap<String, Set<CoreMetaData>>();
        for (String func : taFuncMap.keySet()) {
            CoreMetaData mi = taFuncMap.get(func);
            String group = mi.getFuncInfo().group();
            TreeSet<CoreMetaData> set = (TreeSet<CoreMetaData>)result.get(group);
            if (set == null) {
                set = new TreeSet<CoreMetaData>();
                result.put(group, set);
            }
            set.add(mi);
        }
        return result;
    }

    private static FuncInfo getFuncInfo(Method method) throws IncompleteAnnotationException {
        FuncInfo annotation = method.getAnnotation(FuncInfo.class);
        if (annotation != null) {
            return annotation;
        }
        throw new IncompleteAnnotationException(FuncInfo.class, "Method " + method.getName());
    }

    static CoreMetaData getFuncHandle(String name) throws NoSuchMethodException {
        CoreMetaData mi = CoreMetaData.getAllFuncs().get(name.toUpperCase());
        if (mi == null) {
            throw new NoSuchMethodException(name.toUpperCase());
        }
        mi.callInputParams = null;
        mi.callOutputParams = null;
        mi.callOptInputParams = null;
        if (mi != null) {
            return mi;
        }
        throw new NoSuchMethodException("Function " + name);
    }

    public static CoreMetaData getInstance(String name) throws NoSuchMethodException {
        return CoreMetaData.getFuncHandle(name);
    }

    public FuncInfo getFuncInfo() throws IncompleteAnnotationException {
        return CoreMetaData.getFuncInfo(this.function);
    }

    private Annotation getParameterInfo(int paramIndex, Class<? extends Object> paramAnnotation) {
        if (paramIndex < 0) {
            throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
        }
        int i = 0;
        Annotation[][] annotationArray = this.function.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annArray;
            Annotation[] annotationArray2 = annArray = annotationArray[n2];
            int n3 = annArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray2[n4];
                if (ann.annotationType() == paramAnnotation && paramIndex == i++) {
                    return ann;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private Annotation getParameterInfo(int paramIndex, Class<? extends Object> paramAnnotation, Class<? extends Object> paramExtraAnnotation) {
        if (paramIndex < 0) {
            throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
        }
        int i = 0;
        Annotation[][] annotationArray = this.function.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annArray;
            Annotation[] annotationArray2 = annArray = annotationArray[n2];
            int n3 = annArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray2[n4];
                if (ann.annotationType() == paramAnnotation && paramIndex == i++) {
                    Annotation[] annotationArray3 = annArray;
                    int n5 = annArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Annotation annExt = annotationArray3[n6];
                        if (annExt.annotationType() == paramExtraAnnotation) {
                            return annExt;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public InputParameterInfo getInputParameterInfo(int paramIndex) throws IllegalArgumentException {
        return (InputParameterInfo)this.getParameterInfo(paramIndex, InputParameterInfo.class);
    }

    public OutputParameterInfo getOutputParameterInfo(int paramIndex) throws IllegalArgumentException {
        return (OutputParameterInfo)this.getParameterInfo(paramIndex, OutputParameterInfo.class);
    }

    public OptInputParameterInfo getOptInputParameterInfo(int paramIndex) throws IllegalArgumentException {
        return (OptInputParameterInfo)this.getParameterInfo(paramIndex, OptInputParameterInfo.class);
    }

    public IntegerList getOptInputIntegerList(int paramIndex) throws IllegalArgumentException {
        return (IntegerList)this.getParameterInfo(paramIndex, OptInputParameterInfo.class, IntegerList.class);
    }

    public IntegerRange getOptInputIntegerRange(int paramIndex) throws IllegalArgumentException {
        return (IntegerRange)this.getParameterInfo(paramIndex, OptInputParameterInfo.class, IntegerRange.class);
    }

    public RealList getOptInputRealList(int paramIndex) throws IllegalArgumentException {
        return (RealList)this.getParameterInfo(paramIndex, OptInputParameterInfo.class, RealList.class);
    }

    public RealRange getOptInputRealRange(int paramIndex) throws IllegalArgumentException {
        return (RealRange)this.getParameterInfo(paramIndex, OptInputParameterInfo.class, RealRange.class);
    }

    public void setOptInputParamInteger(int paramIndex, int value) throws IllegalArgumentException {
        IntegerRange range;
        OptInputParameterInfo param = this.getOptInputParameterInfo(paramIndex);
        if (param == null) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (param.type() == OptInputParameterType.TA_OptInput_IntegerList) {
            IntegerList list = this.getOptInputIntegerList(paramIndex);
            int[] nArray = list.value();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int entry = nArray[n2];
                if (value == entry) {
                    if (this.callOptInputParams == null) {
                        this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
                    }
                    this.callOptInputParams[paramIndex] = value;
                    return;
                }
                ++n2;
            }
        } else if (param.type() == OptInputParameterType.TA_OptInput_IntegerRange && value >= (range = this.getOptInputIntegerRange(paramIndex)).min() && value <= range.max()) {
            if (this.callOptInputParams == null) {
                this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
            }
            this.callOptInputParams[paramIndex] = value;
            return;
        }
        throw new InternalError(CONTACT_DEVELOPERS);
    }

    /*
     * Unable to fully structure code
     */
    public void setOptInputParamInteger(int paramIndex, String string) throws IllegalArgumentException {
        block7: {
            try {
                v = new Integer(string);
                this.setOptInputParamInteger(paramIndex, v);
                break block7;
            }
            catch (NumberFormatException v0) {
                param = this.getOptInputParameterInfo(paramIndex);
                if (param == null) {
                    throw new InternalError("Contact developers");
                }
                if (param.type() != OptInputParameterType.TA_OptInput_IntegerList) {
                    throw new InternalError("Contact developers");
                }
                var8_6 = fields = MAType.values();
                var7_7 = fields.length;
                var6_8 = 0;
                ** while (var6_8 < var7_7)
            }
lbl-1000:
            // 1 sources

            {
                value = var8_6[var6_8];
                if (value.name().toUpperCase().equals(string.toUpperCase())) {
                    if (this.callOptInputParams == null) {
                        this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
                    }
                    this.callOptInputParams[paramIndex] = value;
                    return;
                }
                ++var6_8;
                continue;
            }
lbl23:
            // 1 sources

            throw new InternalError("Contact developers");
        }
    }

    public void setOptInputParamReal(int paramIndex, double value) throws IllegalArgumentException {
        RealRange range;
        OptInputParameterInfo param = this.getOptInputParameterInfo(paramIndex);
        if (param.type() == OptInputParameterType.TA_OptInput_RealList) {
            RealList list = this.getOptInputRealList(paramIndex);
            double[] dArray = list.value();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double entry = dArray[n2];
                if (value == entry) {
                    if (this.callOptInputParams == null) {
                        this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
                    }
                    this.callOptInputParams[paramIndex] = value;
                    return;
                }
                ++n2;
            }
        } else if (param.type() == OptInputParameterType.TA_OptInput_RealRange && value >= (range = this.getOptInputRealRange(paramIndex)).min() && value <= range.max()) {
            if (this.callOptInputParams == null) {
                this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
            }
            this.callOptInputParams[paramIndex] = value;
            return;
        }
        throw new InternalError(CONTACT_DEVELOPERS);
    }

    /*
     * Unable to fully structure code
     */
    public void setOptInputParamReal(int paramIndex, String string) throws IllegalArgumentException {
        block6: {
            block7: {
                try {
                    v = new Double(string);
                    this.setOptInputParamReal(paramIndex, v);
                    break block6;
                }
                catch (NumberFormatException v0) {
                    param = this.getOptInputParameterInfo(paramIndex);
                    if (param == null) {
                        throw new InternalError("Contact developers");
                    }
                    if (param.type() != OptInputParameterType.TA_OptInput_RealList) break block7;
                    list = this.getOptInputRealList(paramIndex);
                    i = 0;
                    ** while (i < list.string().length)
                }
lbl-1000:
                // 1 sources

                {
                    if (string.toUpperCase().equals(list.string()[i])) {
                        if (this.callOptInputParams == null) {
                            this.callOptInputParams = new Object[this.getFuncInfo().nbOptInput()];
                        }
                        value = list.value()[i];
                        this.callOptInputParams[paramIndex] = value;
                        return;
                    }
                    ++i;
                    continue;
                }
            }
            throw new InternalError("Contact developers");
        }
    }

    public void setInputParamReal(int paramIndex, Object array) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException(ARRAY_IS_NULL);
        }
        InputParameterInfo param = this.getInputParameterInfo(paramIndex);
        if (param == null || param.type() != InputParameterType.TA_Input_Real) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (!(array instanceof double[])) {
            throw new IllegalArgumentException(DOUBLE_ARRAY_EXPECTED);
        }
        if (this.callInputParams == null) {
            this.callInputParams = new Object[this.getFuncInfo().nbInput()];
        }
        this.callInputParams[paramIndex] = array;
    }

    public void setInputParamInteger(int paramIndex, Object array) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException(ARRAY_IS_NULL);
        }
        InputParameterInfo param = this.getInputParameterInfo(paramIndex);
        if (param == null || param.type() != InputParameterType.TA_Input_Integer) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (!(array instanceof int[])) {
            throw new IllegalArgumentException(INT_ARRAY_EXPECTED);
        }
        if (this.callInputParams == null) {
            this.callInputParams = new Object[this.getFuncInfo().nbInput()];
        }
        this.callInputParams[paramIndex] = array;
    }

    public void setInputParamPrice(int paramIndex, double[] open, double[] high, double[] low, double[] close, double[] volume, double[] openInterest) throws IllegalArgumentException, NullPointerException {
        InputParameterInfo param = this.getInputParameterInfo(paramIndex);
        if (param == null || param.type() != InputParameterType.TA_Input_Price) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (this.callInputParams == null) {
            this.callInputParams = new Object[this.getFuncInfo().nbInput()];
        }
        this.callInputParams[paramIndex] = new PriceInputParameter(param.flags(), open, high, low, close, volume, openInterest);
    }

    public void setInputParamPrice(int paramIndex, Object array) throws IllegalArgumentException, NullPointerException {
        if (array == null) {
            throw new NullPointerException(ARRAY_IS_NULL);
        }
        InputParameterInfo param = this.getInputParameterInfo(paramIndex);
        if (param == null || param.type() != InputParameterType.TA_Input_Price) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (!(array instanceof PriceInputParameter)) {
            throw new IllegalArgumentException(PRICE_EXPECTED);
        }
        if (this.callInputParams == null) {
            this.callInputParams = new Object[this.getFuncInfo().nbInput()];
        }
        this.callInputParams[paramIndex] = array;
    }

    public void setOutputParamReal(int paramIndex, Object array) throws IllegalArgumentException, NullPointerException, ClassCastException {
        if (array == null) {
            throw new NullPointerException(ARRAY_IS_NULL);
        }
        OutputParameterInfo param = this.getOutputParameterInfo(paramIndex);
        if (param == null || param.type() != OutputParameterType.TA_Output_Real) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (!(array instanceof double[])) {
            throw new IllegalArgumentException(DOUBLE_ARRAY_EXPECTED);
        }
        if (this.callOutputParams == null) {
            this.callOutputParams = new Object[this.getFuncInfo().nbOutput()];
        }
        this.callOutputParams[paramIndex] = array;
    }

    public void setOutputParamInteger(int paramIndex, Object array) throws IllegalArgumentException, NullPointerException, ClassCastException {
        if (array == null) {
            throw new NullPointerException(ARRAY_IS_NULL);
        }
        OutputParameterInfo param = this.getOutputParameterInfo(paramIndex);
        if (param == null || param.type() != OutputParameterType.TA_Output_Integer) {
            throw new InternalError(CONTACT_DEVELOPERS);
        }
        if (!(array instanceof int[])) {
            throw new IllegalArgumentException(INT_ARRAY_EXPECTED);
        }
        if (this.callOutputParams == null) {
            this.callOutputParams = new Object[this.getFuncInfo().nbOutput()];
        }
        this.callOutputParams[paramIndex] = array;
    }

    public static void forEachFunc(TaFuncService service) throws Exception {
        for (CoreMetaData mi : CoreMetaData.getAllFuncs().values()) {
            service.execute(mi);
        }
    }

    public static void forEachGrp(TaGrpService service) throws Exception {
        for (String group : CoreMetaData.getAllGrps().keySet()) {
            service.execute(group, taGrpMap.get(group));
        }
    }

    private Object[] getOptInputParameters() {
        int size = this.getFuncInfo().nbOptInput();
        if (this.callOptInputParams == null) {
            this.callOptInputParams = new Object[size];
        }
        int i = 0;
        while (i < size) {
            if (this.callOptInputParams[i] == null) {
                Annotation range;
                Annotation list;
                OptInputParameterInfo param = this.getOptInputParameterInfo(i);
                if (param == null) {
                    throw new InternalError(CONTACT_DEVELOPERS);
                }
                if (param.type() == OptInputParameterType.TA_OptInput_IntegerList) {
                    list = this.getOptInputIntegerList(i);
                    this.callOptInputParams[i] = list.defaultValue();
                } else if (param.type() == OptInputParameterType.TA_OptInput_IntegerRange) {
                    range = this.getOptInputIntegerRange(i);
                    this.callOptInputParams[i] = range.defaultValue();
                } else if (param.type() == OptInputParameterType.TA_OptInput_RealList) {
                    list = this.getOptInputRealList(i);
                    this.callOptInputParams[i] = list.defaultValue();
                } else if (param.type() == OptInputParameterType.TA_OptInput_RealRange) {
                    range = this.getOptInputRealRange(i);
                    this.callOptInputParams[i] = range.defaultValue();
                } else {
                    throw new InternalError(CONTACT_DEVELOPERS);
                }
            }
            ++i;
        }
        return this.callOptInputParams;
    }

    public int getLookback() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = this.getOptInputParameters();
        return (Integer)this.lookback.invoke((Object)taCore, params);
    }

    public void callFunc(int startIndex, int endIndex, MInteger outBegIdx, MInteger outNbElement) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int count = 0;
        Object[] objectArray = this.callInputParams;
        int n = this.callInputParams.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            count = PriceInputParameter.class.isAssignableFrom(item.getClass()) ? (count += ((PriceInputParameter)item).getCount()) : ++count;
            ++n2;
        }
        count += this.callOutputParams.length;
        Object[] params = new Object[(count += this.callOptInputParams.length) + 4];
        count = 0;
        params[count++] = startIndex;
        params[count++] = endIndex;
        Object[] objectArray2 = this.callInputParams;
        int n3 = this.callInputParams.length;
        n = 0;
        while (n < n3) {
            Object item = objectArray2[n];
            if (PriceInputParameter.class.isAssignableFrom(item.getClass())) {
                Object[] objs = ((PriceInputParameter)item).toArrays();
                int i = 0;
                while (i < objs.length) {
                    params[count++] = objs[i];
                    ++i;
                }
            } else {
                params[count++] = item;
            }
            ++n;
        }
        objectArray2 = this.callOptInputParams;
        n3 = this.callOptInputParams.length;
        n = 0;
        while (n < n3) {
            Object item = objectArray2[n];
            params[count++] = item;
            ++n;
        }
        params[count++] = outBegIdx;
        params[count++] = outNbElement;
        objectArray2 = this.callOutputParams;
        n3 = this.callOutputParams.length;
        n = 0;
        while (n < n3) {
            Object item = objectArray2[n];
            params[count++] = item;
            ++n;
        }
        Type[] types = this.function.getGenericParameterTypes();
        if (types.length != params.length) {
            throw new IllegalArgumentException(ILLEGAL_NUMBER_OF_ARGUMENTS);
        }
        this.function.invoke((Object)taCore, params);
    }
}

