/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import pk.com.softech.tradingterminal.InternalErrorDialog;

public final class WorkbenchExceptionHandler {
    private int exceptionCount = 0;
    private InternalErrorDialog dialog;
    private Shell defaultParent = new Shell();
    private boolean closing = false;
    private IWorkbenchConfigurer workbenchConfigurer;
    private static String MSG_OutOfMemoryError = "An out of memory error has occurred.";
    private static String MSG_StackOverflowError = "A stack overflow error has occurred.";
    private static String MSG_VirtualMachineError = "A virtual machine error has occurred.";
    private static String MSG_SWTError = "An SWT error has occurred.";
    private static String MSG_FATAL_ERROR = "{0}\nYou are recommended to exit the workbench.\nSubsequent errors may happen and may terminate the workbench without warning.\nSee the .log file for more details.\n\nDo you want to exit the workbench?";
    private static String MSG_FATAL_ERROR_Recursive = "An internal error occurred while showing an internal error.";
    private static String MSG_FATAL_ERROR_RecursiveTitle = "Internal error";

    public WorkbenchExceptionHandler(IWorkbenchConfigurer configurer) {
        this.workbenchConfigurer = configurer;
    }

    public void handleException(Throwable t) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 1) {
                if (this.closing) {
                    return;
                }
                Shell parent = this.defaultParent;
                if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                    parent = this.dialog.getShell();
                }
                MessageBox box = new MessageBox(parent, 131265);
                box.setText(MSG_FATAL_ERROR_RecursiveTitle);
                box.setMessage(MessageFormat.format(MSG_FATAL_ERROR, MSG_FATAL_ERROR_Recursive));
                int result = box.open();
                if (result == 64) {
                    this.closeWorkbench();
                }
            } else if (this.openQuestionDialog(t)) {
                this.closeWorkbench();
            }
        }
        finally {
            --this.exceptionCount;
        }
    }

    private void closeWorkbench() {
        if (this.closing) {
            return;
        }
        try {
            this.closing = true;
            if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                this.dialog.close();
            }
            this.workbenchConfigurer.emergencyClose();
        }
        catch (RuntimeException re) {
            System.err.println("Fatal runtime error happened during workbench emergency close.");
            re.printStackTrace();
            throw re;
        }
        catch (Error e) {
            System.err.println("Fatal error happened during workbench emergency close.");
            e.printStackTrace();
            throw e;
        }
    }

    private boolean openQuestionDialog(Throwable internalError) {
        try {
            String msg = null;
            if (internalError instanceof OutOfMemoryError) {
                msg = MSG_OutOfMemoryError;
            } else if (internalError instanceof StackOverflowError) {
                msg = MSG_StackOverflowError;
            } else if (internalError instanceof VirtualMachineError) {
                msg = MSG_VirtualMachineError;
            } else if (internalError instanceof SWTError) {
                msg = MSG_SWTError;
            } else {
                msg = internalError.getMessage() == null ? "An internal error has occurred.\nSee the .log file for more details.\n\nDo you want to exit the workbench?" : NLS.bind((String)"An internal error has occurred.\n{0}\nSee the .log file for more details.\n\nDo you want to exit the workbench?", (Object)internalError.getMessage());
                return this.openQuestion(null, "Internal error", msg, internalError, 1);
            }
            Throwable detail = internalError;
            return InternalErrorDialog.openQuestion(null, "Internal error", MessageFormat.format(MSG_FATAL_ERROR, msg), detail, 1);
        }
        catch (Throwable th) {
            System.err.println("Error while informing user about event loop exception:");
            internalError.printStackTrace();
            System.err.println("Dialog open exception:");
            th.printStackTrace();
            return true;
        }
    }

    private boolean openQuestion(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        String[] labels = detail == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        this.dialog = new InternalErrorDialog(parent, title, null, message, detail, 3, labels, defaultIndex);
        if (detail != null) {
            this.dialog.setDetailButton(2);
        }
        boolean result = this.dialog.open() == 0;
        this.dialog = null;
        return result;
    }
}

